\name{pesi_score}
\alias{pesi_score}
\title{
Pulmonary Embolism Severity Index (PESI)
}
\description{
Calculates the Pulmonary Embolism Severity Index (PESI) to stratify the risk of 30-day mortality in patients with confirmed pulmonary embolism (PE). The score sums points derived from 11 clinical variables (demographics, comorbidities, and vital signs).
}
\usage{
pesi_score(age, sex, cancer_history, heart_failure_history, chronic_lung_disease,
           heart_rate, systolic_bp, respiratory_rate, temperature,
           altered_mental_status, oxygen_saturation)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (Points = Age in years).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds 10 points).
}
  \item{cancer_history}{
Numeric (0 or 1). History of cancer. (1 = Yes, +30 points).
}
  \item{heart_failure_history}{
Numeric (0 or 1). History of heart failure. (1 = Yes, +10 points).
}
  \item{chronic_lung_disease}{
Numeric (0 or 1). History of chronic lung disease. (1 = Yes, +10 points).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>= 110 bpm adds 20 points).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (< 100 mmHg adds 30 points).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (>= 30 bpm adds 20 points).
}
  \item{temperature}{
Numeric. Body temperature in degrees Celsius. (< 36 C adds 20 points).
}
  \item{altered_mental_status}{
Numeric (0 or 1). Altered mental status (disorientation, lethargy, stupor, or coma). (1 = Yes, +60 points).
}
  \item{oxygen_saturation}{
Numeric. Arterial oxyhemoglobin saturation (\%). (< 90\% adds 20 points).
}
}
\value{
A list containing:
\item{PESI_Score}{The calculated total score.}
\item{Risk_Class}{The risk classification (Class I - V).}
\item{Est_30_Day_Mortality}{Estimated 30-day all-cause mortality percentage.}
\item{Recommendation}{Clinical guidance on site of care (Outpatient vs. Inpatient).}
}
\references{
Aujesky D, Obrosky DS, Stone RA, et al. Derivation and validation of a prognostic model for pulmonary embolism. Am J Respir Crit Care Med. 2005;172(8):1041-1046. doi:10.1164/rccm.200506-862OC
}
\examples{

# Example 1: High Risk (Class V)
# 80yo Male (+10), Altered Mental Status (+60), SBP 90 (+30)
# Score = 80 + 10 + 60 + 30 = 180
pesi_score(80, "male", 0, 0, 0, 100, 90, 20, 37, 1, 95)

# Example 2: Low Risk (Class II)
# 50yo Female, History of Cancer (+30), stable vitals
# Score = 50 + 0 + 30 = 80
pesi_score(50, "female", 1, 0, 0, 80, 120, 16, 37, 0, 98)
}
