\name{nrs_2002_score}
\alias{nrs_2002_score}
\title{
Nutrition Risk Screening 2002 (NRS-2002)
}
\description{
Calculates the NRS-2002 score to assess nutritional risk in hospitalized patients. The score is the sum of a nutritional status score (0-3), a disease severity score (0-3), and an age adjustment (+1 for age >= 70).
}
\usage{
nrs_2002_score(nutritional_score, disease_severity_score, age)
}
\arguments{
  \item{nutritional_score}{
Numeric (0-3). Impaired nutritional status.
0: Absent.
1 (Mild): Weight loss >5\% in 3 months OR Food intake 50-75\% in preceding week.
2 (Moderate): Weight loss >5\% in 2 months OR BMI 18.5-20.5 + impaired general condition OR Food intake 25-50\% in preceding week.
3 (Severe): Weight loss >5\% in 1 month (>15\% in 3 months) OR BMI <18.5 + impaired general condition OR Food intake 0-25\% in preceding week.
}
  \item{disease_severity_score}{
Numeric (0-3). Severity of disease.
0: Normal nutritional requirements.
1 (Mild): Hip fracture, chronic patients with acute complications (cirrhosis, COPD, hemodialysis, diabetes, oncology).
2 (Moderate): Major abdominal surgery, stroke, severe pneumonia, hematologic malignancy.
3 (Severe): Head injury, bone marrow transplantation, intensive care patients (APACHE >10).
}
  \item{age}{
Numeric. Patient age in years. (Age >= 70 adds 1 point).
}
}
\value{
A list containing:
\item{NRS_2002_Score}{The calculated total score (Range 0-7).}
\item{Interpretation}{Clinical interpretation (Score >= 3 indicates nutritional risk).}
}
\references{
Kondrup J, Rasmussen HH, Hamberg O, Stanga Z; Ad Hoc ESPEN Working Group. Nutritional risk screening (NRS 2002): a new method based on an analysis of controlled clinical trials. Clin Nutr. 2003;22(3):321-336. doi:10.1016/s0261-5614(02)00214-5
}
\examples{

# Example 1: At Risk
# Severe weight loss (3), Hip fracture (1), Age 75 (+1)
# Score = 3 + 1 + 1 = 5
nrs_2002_score(3, 1, 75)

# Example 2: Not At Risk
# Mild intake reduction (1), Normal requirements (0), Age 50 (0)
# Score = 1
nrs_2002_score(1, 0, 50)
}
