\name{neutrophil_lymphocyte_ratio}
\alias{neutrophil_lymphocyte_ratio}
\title{
Neutrophil-Lymphocyte Ratio (NLR)
}
\description{
Calculates the Neutrophil-Lymphocyte Ratio (NLR), a readily available biomarker of systemic inflammation and stress. It is used as a prognostic indicator in various conditions including sepsis, COVID-19, cardiovascular disease, and solid tumors. Elevated NLR is generally associated with worse outcomes.
}
\usage{
neutrophil_lymphocyte_ratio(neutrophil_count, lymphocyte_count)
}
\arguments{
  \item{neutrophil_count}{
Numeric. The absolute neutrophil count (ANC) or percentage of neutrophils.
}
  \item{lymphocyte_count}{
Numeric. The absolute lymphocyte count (ALC) or percentage of lymphocytes. Note: Inputs must use the same unit (absolute count or percentage) for the ratio to be valid.
}
}
\value{
A list containing:
\item{NLR}{The calculated ratio (Neutrophils / Lymphocytes).}
\item{Interpretation}{General clinical context regarding normal vs. elevated ranges.}
}
\references{
Zahorec R. Ratio of neutrophil to lymphocyte counts--rapid and simple parameter of systemic inflammation and stress in critically ill. Bratisl Lek Listy. 2001;102(1):5-14.
Liu Y, Du X, Chen J, et al. Neutrophil-to-lymphocyte ratio as an independent risk factor for mortality in hospitalized patients with COVID-19. J Infect. 2020;81(1):e6-e12. doi:10.1016/j.jinf.2020.04.002
}
\examples{

# Example 1: Normal Range
# Neutrophils 4000, Lymphocytes 2000
# NLR = 2.0
neutrophil_lymphocyte_ratio(4000, 2000)

# Example 2: Elevated (Severe Infection/Stress)
# Neutrophils 8000, Lymphocytes 500
# NLR = 16.0
neutrophil_lymphocyte_ratio(8000, 500)
}
