\name{mrc_icu_score}
\alias{mrc_icu_score}
\title{
Medication Regimen Complexity-Intensive Care Unit (MRC-ICU) Score
}
\description{
Calculates the MRC-ICU score, a tool designed to quantify the complexity of medication regimens in critically ill patients. The score is a weighted sum of prescribed medications and supportive therapies (e.g., mechanical ventilation, dialysis). Higher scores are associated with increased mortality, ICU length of stay, and pharmacist workload.
}
\usage{
mrc_icu_score(aminoglycosides = 0, amphotericin_b = 0, antiarrhythmics = 0,
              anticoagulants_oral = 0, anticonvulsants = 0, argatroban = 0,
              azole_antifungals = 0, blood_products = 0, chemotherapy = 0,
              clozapine = 0, digoxin = 0, ganciclovir_valganciclovir = 0,
              hyperosmolar_fluids = 0, immunosuppressants = 0,
              lidocaine_infusion = 0, lithium = 0, prostacyclins = 0,
              theophylline = 0, therapeutic_heparins = 0, vancomycin_iv = 0,
              warfarin = 0, thromboembolic_prophylaxis = 0,
              stress_ulcer_prophylaxis = 0, glycemic_control = 0,
              bowel_regimen = 0, chlorhexidine = 0, inhalers_nebulizers = 0,
              continuous_sedation = 0, continuous_vasopressors = 0,
              continuous_inotropes = 0, continuous_nmba = 0,
              continuous_iv_fluids = 0, parenteral_nutrition = 0,
              fluid_bolus = 0, renal_replacement_therapy = 0,
              mechanical_ventilation = 0)
}
\arguments{
  \item{aminoglycosides}{Numeric. Number of aminoglycoside orders (e.g., Amikacin, Gentamicin). Weighted 3 points each.}
  \item{amphotericin_b}{Numeric. Number of Amphotericin B orders. Weighted 1 point.}
  \item{antiarrhythmics}{Numeric. Number of antiarrhythmic orders (e.g., Amiodarone, Sotalol). Weighted 1 point.}
  \item{anticoagulants_oral}{Numeric. Number of oral anticoagulant orders (DOACs, Fondaparinux). Weighted 1 point.}
  \item{anticonvulsants}{Numeric. Number of anticonvulsant orders (e.g., Phenytoin, Levetiracetam). Weighted 3 points.}
  \item{argatroban}{Numeric. Number of Argatroban orders. Weighted 2 points.}
  \item{azole_antifungals}{Numeric. Number of Azole antifungal orders (e.g., Voriconazole). Weighted 2 points.}
  \item{blood_products}{Numeric. Number of blood product orders (Factors, ATIII). Weighted 2 points.}
  \item{chemotherapy}{Numeric. Number of active chemotherapy orders. Weighted 3 points.}
  \item{clozapine}{Numeric. Number of Clozapine orders. Weighted 3 points.}
  \item{digoxin}{Numeric. Number of Digoxin orders. Weighted 3 points.}
  \item{ganciclovir_valganciclovir}{Numeric. Number of Ganciclovir/Valganciclovir orders. Weighted 1 point.}
  \item{hyperosmolar_fluids}{Numeric. Number of hyperosmolar fluid orders (Mannitol, Hypertonic Saline). Weighted 1 point.}
  \item{immunosuppressants}{Numeric. Number of immunosuppressant orders (e.g., Tacrolimus, Cyclosporine). Weighted 3 points.}
  \item{lidocaine_infusion}{Numeric. Number of Lidocaine infusion orders. Weighted 2 points.}
  \item{lithium}{Numeric. Number of Lithium orders. Weighted 3 points.}
  \item{prostacyclins}{Numeric. Number of Prostacyclin orders (e.g., Epoprostenol). Weighted 2 points.}
  \item{theophylline}{Numeric. Number of Theophylline orders. Weighted 3 points.}
  \item{therapeutic_heparins}{Numeric. Number of therapeutic heparin/enoxaparin orders. Weighted 2 points.}
  \item{vancomycin_iv}{Numeric. Number of IV Vancomycin orders. Weighted 3 points.}
  \item{warfarin}{Numeric. Number of Warfarin orders. Weighted 3 points.}
  \item{thromboembolic_prophylaxis}{Numeric (0 or 1). Presence of VTE prophylaxis. Weighted 1 point.}
  \item{stress_ulcer_prophylaxis}{Numeric (0 or 1). Presence of stress ulcer prophylaxis. Weighted 1 point.}
  \item{glycemic_control}{Numeric (0 or 1). Presence of glycemic control regimen (insulin). Weighted 1 point.}
  \item{bowel_regimen}{Numeric (0 or 1). Presence of bowel regimen. Weighted 1 point.}
  \item{chlorhexidine}{Numeric (0 or 1). Use of Chlorhexidine. Weighted 1 point.}
  \item{inhalers_nebulizers}{Numeric (0 or 1). Use of inhalers or nebulizers. Weighted 1 point.}
  \item{continuous_sedation}{Numeric (0 or 1). Continuous sedation infusion. Weighted 2 points.}
  \item{continuous_vasopressors}{Numeric. Number of continuous vasopressor infusions. Weighted 3 points each.}
  \item{continuous_inotropes}{Numeric. Number of continuous inotrope infusions. Weighted 3 points each.}
  \item{continuous_nmba}{Numeric. Number of continuous NMBA infusions. Weighted 3 points each.}
  \item{continuous_iv_fluids}{Numeric (0 or 1). Continuous IV fluids. Weighted 1 point.}
  \item{parenteral_nutrition}{Numeric (0 or 1). TPN/PPN use. Weighted 3 points.}
  \item{fluid_bolus}{Numeric (0 or 1). Fluid bolus administration. Weighted 1 point.}
  \item{renal_replacement_therapy}{Numeric (0 or 1). RRT/Dialysis. Weighted 3 points.}
  \item{mechanical_ventilation}{Numeric (0 or 1). Mechanical ventilation. Weighted 3 points.}
}
\value{
A list containing:
\item{MRC_ICU_Score}{The total calculated score.}
\item{Interpretation}{Context regarding score implications.}
}
\references{
Sikora A, Awdishu L, Palmer H, et al. Validation of the Medication Regimen Complexity-ICU (MRC-ICU) Score.
}
\examples{
# Example 1: High Complexity
# Vancomycin (3), Norepinephrine (3), Vent (3), Sedation (2)
mrc_icu_score(vancomycin_iv = 1, continuous_vasopressors = 1,
              mechanical_ventilation = 1, continuous_sedation = 1)

# Example 2: Low Complexity
# Prophylaxis only (VTE 1, Ulcer 1, Bowel 1)
mrc_icu_score(thromboembolic_prophylaxis = 1, stress_ulcer_prophylaxis = 1,
              bowel_regimen = 1)
}
