\name{modified_sofa_score}
\alias{modified_sofa_score}
\title{
Modified Sequential Organ Failure Assessment (mSOFA) Score
}
\description{
Calculates the Modified SOFA (mSOFA) score, which replaces the PaO2/FiO2 ratio used in the standard SOFA score with the SpO2/FiO2 ratio. This allows for organ failure assessment without requiring arterial blood gas analysis.
}
\usage{
modified_sofa_score(spo2_percent, fio2_percent, platelet_count, bilirubin_mg_dl,
                    hypotension_level, gcs_score, creatinine_mg_dl)
}
\arguments{
  \item{spo2_percent}{
Numeric. Oxygen saturation percentage (0-100).
}
  \item{fio2_percent}{
Numeric. Fraction of inspired oxygen (e.g., 21 for Room Air, 100 for 100\%). Can be entered as percent (21-100) or fraction (0.21-1.0).
}
  \item{platelet_count}{
Numeric. Platelet count in x10^3/uL.
}
  \item{bilirubin_mg_dl}{
Numeric. Total Bilirubin in mg/dL.
}
  \item{hypotension_level}{
Numeric (0-4). Cardiovascular score based on MAP and vasopressor support:
0: MAP >= 70 mmHg.
1: MAP < 70 mmHg.
2: Dopamine <= 5 mcg/kg/min or Dobutamine (any dose).
3: Dopamine > 5 or Epinephrine <= 0.1 or Norepinephrine <= 0.1.
4: Dopamine > 15 or Epinephrine > 0.1 or Norepinephrine > 0.1.
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score (3-15).
}
  \item{creatinine_mg_dl}{
Numeric. Serum Creatinine in mg/dL.
}
}
\value{
A list containing:
\item{mSOFA_Score}{The calculated total score (Range 0-24).}
\item{Mortality_Estimate}{Approximate mortality risk associated with the score range.}
\item{Subscores}{Individual scores for each organ system.}
}
\references{
Grissom CK, Brown SM, Kuttler KG, et al. A modified sequential organ failure assessment score for critical care triage. Disaster Med Public Health Prep. 2010;4(4):277-284. doi:10.1001/dmp.2010.40
}
\examples{

# Example 1: Moderate Severity
# SpO2 92% on 50% FiO2 (S/F=184 -> 3pts), Plt 120 (1pt), Bili 1.0 (0pt),
# MAP<70 (1pt), GCS 14 (1pt), Cr 1.3 (1pt)
modified_sofa_score(92, 50, 120, 1.0, 1, 14, 1.3)

# Example 2: Severe
# SpO2 88% on 100% (S/F=88 -> 4pts), Plt 40 (3pts), Bili 3.0 (2pts),
# Norepi >0.1 (4pts), GCS 9 (3pts), Cr 4.0 (3pts)
modified_sofa_score(88, 100, 40, 3.0, 4, 9, 4.0)
}
