\name{modified_asthma_predictive_index}
\alias{modified_asthma_predictive_index}
\title{
Modified Asthma Predictive Index (mAPI)
}
\description{
Calculates the Modified Asthma Predictive Index (mAPI) for young children (<= 3 years) with frequent wheezing. A positive mAPI predicts a high likelihood of developing asthma by school age. The index requires frequent wheezing (>3 episodes/year) plus either 1 Major criterion or 2 Minor criteria.
}
\usage{
modified_asthma_predictive_index(age, wheezing_episodes_gt_3_per_year,
                                 parental_asthma, eczema, aeroallergen_sensitization,
                                 food_sensitization, wheezing_apart_from_colds,
                                 eosinophilia_gt_4_percent)
}
\arguments{
  \item{age}{
Numeric. Age of the child in years. (Tool is validated for young children, typically <= 3).
}
  \item{wheezing_episodes_gt_3_per_year}{
Numeric (0 or 1). Does the child have >3 episodes of wheezing per year? (1 = Yes). This is a prerequisite for a positive score.
}
  \item{parental_asthma}{
Numeric (0 or 1). Parent with physician-diagnosed asthma. (Major Criterion).
}
  \item{eczema}{
Numeric (0 or 1). Physician-diagnosed atopic dermatitis (eczema). (Major Criterion).
}
  \item{aeroallergen_sensitization}{
Numeric (0 or 1). Sensitization to at least one aeroallergen (positive skin prick test or specific IgE). (Major Criterion).
}
  \item{food_sensitization}{
Numeric (0 or 1). Sensitization to milk, eggs, or peanuts. (Minor Criterion).
}
  \item{wheezing_apart_from_colds}{
Numeric (0 or 1). Wheezing apart from colds. (Minor Criterion).
}
  \item{eosinophilia_gt_4_percent}{
Numeric (0 or 1). Peripheral blood eosinophilia >= 4\%. (Minor Criterion).
}
}
\value{
A list containing:
\item{mAPI_Result}{"Positive mAPI" or "Negative mAPI".}
\item{Prediction}{Prognostic interpretation regarding future asthma development.}
\item{Criteria_Met}{Summary of major and minor criteria counts.}
}
\references{
Guilbert TW, Morgan WJ, Zeiger RS, et al. Atopic characteristics of children with recurrent wheezing at high risk for the development of childhood asthma. J Allergy Clin Immunol. 2004;114(6):1282-1287. doi:10.1016/j.jaci.2004.09.020
Chang TS, Lemanske RF Jr, Guilbert TW, et al. Evaluation of the modified asthma predictive index in high-risk preschool children. J Allergy Clin Immunol Pract. 2013;1(2):152-156. doi:10.1016/j.jaip.2012.10.008
}
\examples{

# Example 1: Positive mAPI
# Frequent wheezing (1), Eczema (1 Major), Eosinophilia
#(1 Minor - insufficient alone, but 1 major is enough)
# Result: Positive
modified_asthma_predictive_index(2, 1, 0, 1, 0, 0, 0, 1)

# Example 2: Negative mAPI
# Frequent wheezing (1), Only 1 Minor (Eosinophilia)
# Result: Negative
modified_asthma_predictive_index(3, 1, 0, 0, 0, 0, 0, 1)
}
