\name{mipi_lymphoma_score}
\alias{mipi_lymphoma_score}
\title{
Mantle Cell Lymphoma International Prognostic Index (MIPI)
}
\description{
Calculates the MIPI score to predict overall survival in patients with advanced-stage mantle cell lymphoma (MCL). The score is a continuous variable derived from age, ECOG performance status, lactate dehydrogenase (LDH) ratio, and white blood cell (WBC) count.
}
\usage{
mipi_lymphoma_score(age, ecog_score, ldh_level, ldh_uln, wbc_count)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{ecog_score}{
Numeric. Eastern Cooperative Oncology Group (ECOG) performance status (0-4). Scores 0-1 are weighted as 0; scores 2-4 are weighted as 1 in the algorithm.
}
  \item{ldh_level}{
Numeric. Patient's serum LDH level.
}
  \item{ldh_uln}{
Numeric. The laboratory's Upper Limit of Normal for LDH.
}
  \item{wbc_count}{
Numeric. White Blood Cell count in x10^9/L (or cells/uL / 1000).
}
}
\value{
A list containing:
\item{MIPI_Score}{The calculated prognostic score.}
\item{Risk_Group}{Classification (Low < 5.7, Intermediate 5.7-6.2, High >= 6.2).}
\item{Median_Overall_Survival}{Estimated median survival time based on the original cohort.}
}
\references{
Hoster E, Dreyling M, Klapper W, et al. A new prognostic index (MIPI) for patients with advanced-stage mantle cell lymphoma. Blood. 2008;111(2):558-565. doi:10.1182/blood-2007-06-095331
}
\examples{

# Example 1: High Risk
# Age 80 (2.8), ECOG 3 (0.7), LDH 1000/200 (Ratio 5 -> log10(5)=0.7, 1.367*0.7=0.95),
#WBC 50 (log10(50)=1.7, 0.94*1.7=1.6)
# Sum = 2.8 + 0.7 + 0.95 + 1.6 = 6.05 (Intermediate).
mipi_lymphoma_score(80, 3, 1000, 200, 50)

# Example 2: Low Risk
# Age 50, ECOG 0, LDH 150 (ULN 200 -> 0.75), WBC 5
# Score = 1.76 + 0 + (1.367 * -0.12) + (0.9393 * 0.7) = 1.76 - 0.16 + 0.66 = 2.26
mipi_lymphoma_score(50, 0, 150, 200, 5)
}
