\name{mentzer_index}
\alias{mentzer_index}
\title{
Mentzer Index for Microcytic Anemia
}
\description{
Calculates the Mentzer Index to help differentiate between iron deficiency anemia and beta-thalassemia trait in patients with microcytic anemia. The index is the ratio of Mean Corpuscular Volume (MCV) to Red Blood Cell count (RBC).
}
\usage{
mentzer_index(mcv, rbc_count)
}
\arguments{
  \item{mcv}{
Numeric. Mean Corpuscular Volume in fL.
}
  \item{rbc_count}{
Numeric. Red Blood Cell count in Millions/uL (x10^12/L).
}
}
\value{
A list containing:
\item{Mentzer_Index}{The calculated index value.}
\item{Interpretation}{Diagnostic suggestion (<13 favors Thalassemia, >13 favors Iron Deficiency).}
}
\references{
Mentzer WC Jr. Differentiation of iron deficiency from thalassaemia trait. Lancet. 1973;1(7808):882. doi:10.1016/s0140-6736(73)91446-3
}
\examples{

# Example 1: Thalassemia Trait Likely
# MCV 65, RBC 5.5
# Index = 65 / 5.5 = 11.8
mentzer_index(65, 5.5)

# Example 2: Iron Deficiency Likely
# MCV 70, RBC 3.5
# Index = 70 / 3.5 = 20
mentzer_index(70, 3.5)
}
