\name{lights_criteria_effusion}
\alias{lights_criteria_effusion}
\title{
Light's Criteria for Pleural Effusion
}
\description{
Applies Light's Criteria to differentiate between transudative and exudative pleural effusions. An effusion is classified as exudative if at least one of the three criteria is met:
1. Pleural fluid protein / Serum protein > 0.5
2. Pleural fluid LDH / Serum LDH > 0.6
3. Pleural fluid LDH > 2/3 * Serum LDH Upper Limit of Normal (ULN)
}
\usage{
lights_criteria_effusion(pleural_protein, serum_protein, pleural_ldh,
                         serum_ldh, serum_ldh_uln)
}
\arguments{
  \item{pleural_protein}{
Numeric. Pleural fluid protein level (g/dL).
}
  \item{serum_protein}{
Numeric. Serum protein level (g/dL).
}
  \item{pleural_ldh}{
Numeric. Pleural fluid Lactate Dehydrogenase (LDH) level (U/L).
}
  \item{serum_ldh}{
Numeric. Serum Lactate Dehydrogenase (LDH) level (U/L).
}
  \item{serum_ldh_uln}{
Numeric. The laboratory's upper limit of normal for serum LDH (U/L).
}
}
\value{
A list containing:
\item{Classification}{"Exudative" or "Transudative".}
\item{Criteria_Met}{A list of the specific criteria that triggered the exudative classification.}
\item{Calculated_Values}{The calculated ratios and thresholds used.}
}
\references{
Light RW, Macgregor MI, Luchsinger PC, Ball WC Jr. Pleural effusions: the diagnostic separation of transudates and exudates. Ann Intern Med. 1972;77(4):507-513. doi:10.7326/0003-4819-77-4-507
}
\examples{

# Example 1: Exudative (High Protein Ratio)
# P-Prot 4.0, S-Prot 6.0 (Ratio 0.66), LDH normal
lights_criteria_effusion(4.0, 6.0, 100, 200, 250)

# Example 2: Transudative
# P-Prot 2.0, S-Prot 7.0 (Ratio 0.28), P-LDH 80, S-LDH 200, ULN 250
# All ratios low
lights_criteria_effusion(2.0, 7.0, 80, 200, 250)
}
