\name{lansky_play_performance_scale}
\alias{lansky_play_performance_scale}
\title{
Lansky Play Performance Scale
}
\description{
Retrieves the clinical definition for the Lansky Play Performance Scale score. This tool is designed to assess the functional status of children (typically ages 1-16) with cancer or other serious illnesses based on their ability to engage in play and daily activities.
}
\usage{
lansky_play_performance_scale(score)
}
\arguments{
  \item{score}{
Numeric. The assigned Lansky score. Must be a multiple of 10 between 0 and 100.
}
}
\value{
A list containing:
\item{Lansky_Score}{The input score.}
\item{Definition}{The description of the child's play performance capability.}
\item{Restriction_Level}{General categorization of the functional impairment.}
}
\references{
Lansky SB, List MA, Lansky LL, Ritter-Sterr C, Miller DR. The measurement of performance in childhood cancer patients. Cancer. 1987;60(7):1651-1656. doi:10.1002/1097-0142(19871001)60:7<1651::aid-cncr2820600738>3.0.co;2-j
}
\examples{

# Example 1: Active child, tires easily
lansky_play_performance_scale(80)

# Example 2: Mostly in bed
lansky_play_performance_scale(40)
}
