\name{irae_nephritis_grading}
\alias{irae_nephritis_grading}
\title{
irAE Grading for Nephritis (Renal Toxicities)
}
\description{
Calculates the CTCAE severity grade for immune-mediated nephritis associated with immune checkpoint inhibitor (ICPi) therapy. Grading is determined by the elevation of serum creatinine relative to the Upper Limit of Normal (ULN) or the patient's baseline creatinine.
}
\usage{
irae_nephritis_grading(creatinine_level, creatinine_uln,
                       baseline_creatinine = NULL, life_threatening = 0)
}
\arguments{
  \item{creatinine_level}{
Numeric. Current serum creatinine level in mg/dL.
}
  \item{creatinine_uln}{
Numeric. The laboratory's Upper Limit of Normal for creatinine.
}
  \item{baseline_creatinine}{
Numeric (Optional). The patient's pre-treatment baseline creatinine level. Used for grading (e.g., >1.5x baseline).
}
  \item{life_threatening}{
Numeric (0 or 1). Are there life-threatening consequences (e.g., dialysis indicated)? (1 = Yes).
}
}
\value{
A list containing:
\item{CTCAE_Grade}{The calculated adverse event grade (0-4).}
\item{Definition}{Clinical description of the grade criteria met.}
\item{Management_Recommendation}{Guidance on ICPi continuation and immunosuppressive therapy based on ASCO guidelines.}
}
\references{
Brahmer JR, Lacchetti C, Schneider BJ, et al. Management of Immune-Related Adverse Events in Patients Treated With Immune Checkpoint Inhibitor Therapy: American Society of Clinical Oncology Clinical Practice Guideline. J Clin Oncol. 2018;36(17):1714-1768. doi:10.1200/JCO.2017.77.6385
}
\examples{

# Example 1: Grade 2 Nephritis (Based on ULN)
# Cr 2.0 (ULN 1.2 -> ratio 1.66)
irae_nephritis_grading(2.0, 1.2)

# Example 2: Grade 3 Nephritis (Based on Baseline)
# Cr 3.5 (Baseline 1.0 -> ratio 3.5)
irae_nephritis_grading(3.5, 1.2, baseline_creatinine = 1.0)
}
