\name{heart_pathway_early_discharge}
\alias{heart_pathway_early_discharge}
\title{
HEART Pathway for Early Discharge in Acute Chest Pain
}
\description{
Calculates the HEART Pathway result to identify patients with acute chest pain who can be safely discharged from the Emergency Department. The pathway combines the HEART Score (History, ECG, Age, Risk Factors, Initial Troponin) with a serial 3-hour troponin measurement.
}
\usage{
heart_pathway_early_discharge(history_score, ecg_score, age,
                              risk_factors_score, initial_troponin_score,
                              troponin_3h_negative)
}
\arguments{
  \item{history_score}{
Numeric (0-2). History suspicion: 0=Slightly, 1=Moderately, 2=Highly suspicious.
}
  \item{ecg_score}{
Numeric (0-2). ECG findings: 0=Normal, 1=Non-specific repolarization, 2=Significant ST deviation.
}
  \item{age}{
Numeric. Patient age in years. (Score calculated internally: <45=0, 45-64=1, >=65=2).
}
  \item{risk_factors_score}{
Numeric (0-2). Risk Factors: 0=None, 1=1-2 factors, 2=3+ factors or History of CAD.
}
  \item{initial_troponin_score}{
Numeric (0-2). Initial Troponin: 0=<=limit, 1=1-2x limit, 2=>2x limit.
}
  \item{troponin_3h_negative}{
Numeric (0 or 1). Is the 3-hour repeat troponin negative/normal? (1 = Yes, 0 = No/Not Done).
}
}
\value{
A list containing:
\item{HEART_Score}{The calculated HEART score (Range 0-10).}
\item{Pathway_Result}{Classification as "Low Risk" or "Not Low Risk".}
\item{Recommendation}{Guidance on discharge vs. admission.}
}
\references{
Mahler SA, Riley RF, Hiestand BC, et al. The HEART Pathway randomized trial: identifying emergency department patients with acute chest pain for early discharge. Circ Cardiovasc Qual Outcomes. 2015;8(2):195-203. doi:10.1161/CIRCOUTCOMES.114.001384
}
\examples{

# Example 1: Low Risk Candidate
# Hx Moderate(1), ECG Normal(0), Age 40(0), Risk Factors 1(1), Trop 0(0), 3h Trop Neg(1)
# HEART Score = 2. Pathway: Low Risk.
heart_pathway_early_discharge(1, 0, 40, 1, 0, 1)

# Example 2: High Risk (Score > 3)
# Hx High(2), ECG Non-spec(1), Age 50(1), Risk Factors 2(2), Trop 0(0), 3h Trop Neg(1)
# HEART Score = 6. Pathway: Not Low Risk.
heart_pathway_early_discharge(2, 1, 50, 2, 0, 1)
}
