\name{glasgow_alcoholic_hepatitis_score}
\alias{glasgow_alcoholic_hepatitis_score}
\title{
Glasgow Alcoholic Hepatitis Score (GAHS)
}
\description{
Calculates the Glasgow Alcoholic Hepatitis Score (GAHS) to predict the prognosis of patients with alcoholic hepatitis. The score ranges from 5 to 12, based on Age, White Blood Cell count, Urea, Prothrombin Time (INR), and Bilirubin. A score of 9 or higher indicates a poor prognosis and may guide the use of corticosteroids (specifically for patients with a discriminant function >= 32).
}
\usage{
glasgow_alcoholic_hepatitis_score(age, wbc_count, urea, pt_inr, bilirubin,
                                  bilirubin_units = "mg/dL", urea_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (<50: 1 pt, >=50: 2 pts).
}
  \item{wbc_count}{
Numeric. White Blood Cell count in 10^9/L. (<15: 1 pt, >=15: 2 pts).
}
  \item{urea}{
Numeric. Blood Urea Nitrogen (BUN) or Urea. (<5 mmol/L: 1 pt, >=5 mmol/L: 2 pts).
}
  \item{pt_inr}{
Numeric. INR ratio. (<1.5: 1 pt, 1.5-2.0: 2 pts, >=2.0: 3 pts).
}
  \item{bilirubin}{
Numeric. Total Bilirubin level. (<125 umol/L: 1 pt, 125-250: 2 pts, >=250: 3 pts).
}
  \item{bilirubin_units}{
String. Units for bilirubin. "mg/dL" (default) or "umol/L".
}
  \item{urea_units}{
String. Units for urea input. "mg/dL" (default, assumed BUN) or "mmol/L".
}
}
\value{
A list containing:
\item{GAHS_Score}{The calculated score (Range 5-12).}
\item{Survival_28_Day}{Estimated 28-day survival percentage.}
\item{Survival_84_Day}{Estimated 84-day survival percentage.}
}
\references{
Forrest EH, Evans CD, Stewart S, et al. Analysis of factors predictive of mortality in alcoholic hepatitis and derivation and validation of the Glasgow alcoholic hepatitis score. Gut. 2005;54(8):1174-1179. doi:10.1136/gut.2004.050781
}
\examples{

# Example 1: High Risk (Score >= 9)
# Age 55 (2), WBC 18 (2), BUN 30 (~10mmol) (2), INR 2.2 (3), Bili 15 (~256umol) (3)
# Score = 2+2+2+3+3 = 12
glasgow_alcoholic_hepatitis_score(55, 18, 30, 2.2, 15)

# Example 2: Low Risk (Score < 9)
# Age 40 (1), WBC 10 (1), BUN 10 (~3.5mmol) (1), INR 1.2 (1), Bili 2 (~34umol) (1)
# Score = 5
glasgow_alcoholic_hepatitis_score(40, 10, 10, 1.2, 2)
}
