\name{esus_criteria}
\alias{esus_criteria}
\title{
Embolic Stroke of Undetermined Source (ESUS) Criteria
}
\description{
Evaluates whether a patient meets the criteria for Embolic Stroke of Undetermined Source (ESUS). This classification requires the visualization of a non-lacunar ischemic stroke and the exclusion of other specific causes such as atherosclerosis, cardioembolism, and other uncommon etiologies.
}
\usage{
esus_criteria(ischemic_stroke_ct_mri, extracranial_stenosis_lt_50,
              afib_flutter_absent, cardiac_embolism_source_absent,
              other_causes_absent)
}
\arguments{
  \item{ischemic_stroke_ct_mri}{
Numeric (0 or 1). Ischemic stroke visualized on CT or MRI that is not lacunar? (1 = Yes).
}
  \item{extracranial_stenosis_lt_50}{
Numeric (0 or 1). Absence of extracranial or intracranial atherosclerosis causing >= 50\% luminal stenosis in arteries supplying the ischemic area? (1 = Yes/Absent).
}
  \item{afib_flutter_absent}{
Numeric (0 or 1). No major-risk cardioembolic source of embolism? (Specifically AFib/Flutter). Requires >= 24 hours of cardiac monitoring. (1 = Yes/Absent).
}
  \item{cardiac_embolism_source_absent}{
Numeric (0 or 1). No other major-risk cardioembolic source? (e.g., intracardiac thrombus, prosthetic valve, atrial myxoma, recent MI <4 weeks, LVEF <30\%, etc.). (1 = Yes/Absent).
}
  \item{other_causes_absent}{
Numeric (0 or 1). No other specific cause of stroke identified (e.g., arteritis, dissection, migraine, drug misuse)? (1 = Yes/Absent).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met" or "Criteria Not Met".}
\item{Missing_Criteria}{List of exclusion criteria that failed, if any.}
}
\references{
Hart RG, Diener HC, Coutts SB, et al. Embolic strokes of undetermined source: the case for a new clinical construct. Lancet Neurol. 2014;13(4):429-438. doi:10.1016/S1474-4422(13)70310-7
}
\examples{

# Example 1: Diagnosis Confirmed
# Non-lacunar stroke, no stenosis, no AFib, no cardiac source, no other cause
esus_criteria(1, 1, 1, 1, 1)

# Example 2: Diagnosis Not Met (AFib present)
# Non-lacunar stroke, no stenosis, but AFib detected (input 0 for 'absent')
esus_criteria(1, 1, 0, 1, 1)
}
