\name{duval_cibmtr_aml_survival}
\alias{duval_cibmtr_aml_survival}
\title{
Duval/CIBMTR Score for AML Survival
}
\description{
Calculates the Duval/CIBMTR score to predict 3-year overall survival in patients with active Acute Myelogenous Leukemia (AML) undergoing hematopoietic cell transplantation (HCT). The score stratifies patients based on disease status, cytogenetics, donor match, circulating blasts, and performance status.
}
\usage{
duval_cibmtr_aml_survival(disease_group, cytogenetics, hla_match,
                          circulating_blasts, karnofsky_score)
}
\arguments{
  \item{disease_group}{
Numeric (0 or 1). Disease status group.
0: Primary induction failure OR Duration of first complete remission > 6 months.
1: Duration of first complete remission < 6 months (or relapse within 6 months).
}
  \item{cytogenetics}{
Numeric (0 or 1). Cytogenetic risk group.
0: Good or Intermediate.
1: Poor.
}
  \item{hla_match}{
Numeric (0 or 1). Donor HLA match type.
0: HLA-identical sibling or well-matched/partially-matched unrelated donor.
1: Mismatched unrelated donor or related other than HLA-identical sibling. (+2 points).
}
  \item{circulating_blasts}{
Numeric (0 or 1). Presence of circulating blasts at the time of transplant. (1 = Present, +1 point).
}
  \item{karnofsky_score}{
Numeric (0 or 1). Karnofsky Performance Status (KPS) or Lansky scale.
0: 90-100.
1: < 90. (+1 point).
}
}
\value{
A list containing:
\item{Duval_CIBMTR_Score}{The calculated score (Range 0-6).}
\item{Estimated_3_Year_Survival}{The predicted 3-year overall survival probability.}
}
\references{
Duval M, Klein JP, He W, et al. Hematopoietic stem-cell transplantation for acute leukemia in relapse or primary induction failure. J Clin Oncol. 2010;28(23):3730-3738. doi:10.1200/JCO.2010.28.8852
}
\examples{

# Example 1: Good Prognosis
# CR1 > 6mo (0), Good Cyto (0), Matched Sib (0), No Blasts (0), KPS 90 (0)
# Score = 0
duval_cibmtr_aml_survival(0, 0, 0, 0, 0)

# Example 2: Poor Prognosis
# CR1 < 6mo (1), Poor Cyto (1), Mismatched Donor (1 -> +2pts), Blasts Present (1), KPS 80 (1)
# Score = 1 + 1 + 2 + 1 + 1 = 6
duval_cibmtr_aml_survival(1, 1, 1, 1, 1)
}
