\name{cts6_score}
\alias{cts6_score}
\title{
Carpal Tunnel Syndrome 6 (CTS-6)
}
\description{
Calculates the CTS-6 score, a validated clinical diagnostic tool for Carpal Tunnel Syndrome. The score assigns weighted points to six history and physical examination findings to estimate the probability of CTS. A score of 12 or higher indicates a high probability of CTS.
}
\usage{
cts6_score(numbness_median_territory, nocturnal_numbness,
           thenar_atrophy_weakness, phalens_test, tinels_sign,
           two_point_discrim_gt_5mm)
}
\arguments{
  \item{numbness_median_territory}{
Numeric (0 or 1). Numbness primarily in the median nerve distribution (thumb, index, middle, radial half of ring finger). (1 = Yes, +3.5 points).
}
  \item{nocturnal_numbness}{
Numeric (0 or 1). Numbness waking the patient at night. (1 = Yes, +4.0 points).
}
  \item{thenar_atrophy_weakness}{
Numeric (0 or 1). Observation of thenar atrophy or weakness of thumb abduction. (1 = Yes, +5.0 points).
}
  \item{phalens_test}{
Numeric (0 or 1). Positive Phalen's test (numbness/tingling within 60 seconds of wrist flexion). (1 = Yes, +5.0 points).
}
  \item{tinels_sign}{
Numeric (0 or 1). Positive Tinel's sign (tingling/shock sensation on tapping median nerve). (1 = Yes, +4.0 points).
}
  \item{two_point_discrim_gt_5mm}{
Numeric (0 or 1). Two-point discrimination > 5 mm in the median nerve distribution. (1 = Yes, +4.5 points).
}
}
\value{
A list containing:
\item{CTS6_Score}{The calculated total score (Range 0-26).}
\item{Probability_Category}{Estimated probability of CTS (Low <5, Intermediate 5-12, High >12).}
}
\references{
Atroshi I, Lyren PE, Gummesson C. The 6-item CTS symptoms scale: a brief outcomes measure for carpal tunnel syndrome. J Hand Surg Am. 2009;34(2):196-204.
Graham B. The value added by electrodiagnostic testing in the diagnosis of carpal tunnel syndrome. J Bone Joint Surg Am. 2008;90(12):2587-2593.
}
\examples{

# Example 1: High Probability
# Numbness median (+3.5), Nocturnal (+4), Phalen's (+5)
# Score = 12.5
cts6_score(1, 1, 0, 1, 0, 0)

# Example 2: Low Probability
# Only Tinel's sign present
# Score = 4.0
cts6_score(0, 0, 0, 0, 1, 0)
}
