\name{cssrs_screener}
\alias{cssrs_screener}
\title{
Columbia-Suicide Severity Rating Scale (C-SSRS) Screener
}
\description{
Calculates the risk stratification based on the C-SSRS Screener (Recent). This tool assesses the severity of suicidal ideation (1-5) and the presence of recent suicidal behavior to triage patients into Low, Moderate, or High risk categories for self-harm.
}
\usage{
cssrs_screener(wish_to_be_dead, suicidal_thoughts, thoughts_with_method,
               intent_without_plan, intent_with_plan, suicidal_behavior_3mo)
}
\arguments{
  \item{wish_to_be_dead}{
Numeric (0 or 1). Q1: Have you wished you were dead or wished you could go to sleep and not wake up? (1 = Yes).
}
  \item{suicidal_thoughts}{
Numeric (0 or 1). Q2: Have you actually had any thoughts of killing yourself? (1 = Yes).
}
  \item{thoughts_with_method}{
Numeric (0 or 1). Q3: Have you been thinking about how you might do this? (1 = Yes).
}
  \item{intent_without_plan}{
Numeric (0 or 1). Q4: Have you had these thoughts and had some intention of acting on them? (1 = Yes).
}
  \item{intent_with_plan}{
Numeric (0 or 1). Q5: Have you started to work out or worked out the details of how to kill yourself? Do you intend to carry out this plan? (1 = Yes).
}
  \item{suicidal_behavior_3mo}{
Numeric (0 or 1). Q6: Have you done anything, started to do anything, or prepared to do anything to end your life in the past 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Level}{The determined risk category (None, Low, Moderate, High).}
\item{Triage_Color}{Corresponding triage color (Green, Yellow, Orange, Red).}
\item{Recommended_Action}{Clinical guidance for safety/observation based on risk.}
\item{Max_Ideation_Severity}{The highest level of ideation endorsed (0-5).}
}
\references{
Posner K, Brown GK, Stanley B, et al. The Columbia-Suicide Severity Rating Scale: initial validity and internal consistency findings from three multisite studies with adolescents and adults. Am J Psychiatry. 2011;168(12):1266-1277. doi:10.1176/appi.ajp.2011.10111704
}
\examples{

# Example 1: High Risk (Intent with Plan)
# Q1-Q5 Yes, No recent behavior
cssrs_screener(1, 1, 1, 1, 1, 0)

# Example 2: Low Risk (Wish to be dead only)
# Q1 Yes, others No
cssrs_screener(1, 0, 0, 0, 0, 0)
}
