\name{cornell_assessment_pediatric_delirium}
\alias{cornell_assessment_pediatric_delirium}
\title{
Cornell Assessment for Pediatric Delirium (CAPD)
}
\description{
Calculates the CAPD score to screen for delirium in critically ill infants and children. The scale consists of 8 observational items scored from 0 to 4. For items 1-4 (developmental behaviors), higher scores indicate absence of the behavior (reverse scoring is assumed to be done prior to input or user enters points directly). For items 5-8 (symptomatic behaviors), higher scores indicate frequency of the symptom.
}
\usage{
cornell_assessment_pediatric_delirium(q1_eye_contact, q2_purposeful_actions,
                                      q3_aware_surroundings, q4_communicate_needs,
                                      q5_restless, q6_inconsolable,
                                      q7_underactive, q8_response_time)
}
\arguments{
  \item{q1_eye_contact}{
Numeric (0-4). Score for eye contact with caregiver. (0=Always, 4=Never).
}
  \item{q2_purposeful_actions}{
Numeric (0-4). Score for purposeful actions. (0=Always, 4=Never).
}
  \item{q3_aware_surroundings}{
Numeric (0-4). Score for awareness of surroundings. (0=Always, 4=Never).
}
  \item{q4_communicate_needs}{
Numeric (0-4). Score for communicating needs/wants. (0=Always, 4=Never).
}
  \item{q5_restless}{
Numeric (0-4). Score for restlessness. (0=Never, 4=Always).
}
  \item{q6_inconsolable}{
Numeric (0-4). Score for being inconsolable. (0=Never, 4=Always).
}
  \item{q7_underactive}{
Numeric (0-4). Score for being underactive. (0=Never, 4=Always).
}
  \item{q8_response_time}{
Numeric (0-4). Score for delayed response time. (0=Never, 4=Always).
}
}
\value{
A list containing:
\item{CAPD_Total_Score}{The sum of the 8 item scores (Range 0-32).}
\item{Interpretation}{Screening result based on the cutoff of 9.}
}
\references{
Traube C, Silver G, Kearney J, et al. Cornell Assessment of Pediatric Delirium: a valid, rapid, observational tool for screening delirium in the PICU. Crit Care Med. 2014;42(3):656-663. doi:10.1097/CCM.0b013e3182a66b76
}
\examples{

# Example 1: Positive for Delirium
# Child never makes eye contact (4), is always restless (4), score 8 from just two items
# Total = 4+4+0+0+4+0+0+0 = 12
cornell_assessment_pediatric_delirium(4, 4, 0, 0, 4, 0, 0, 0)

# Example 2: Negative for Delirium
# Normal behaviors (0 points each)
cornell_assessment_pediatric_delirium(0, 0, 0, 0, 0, 0, 0, 0)
}
