\name{child_pugh_score}
\alias{child_pugh_score}
\title{
Child-Pugh Score for Cirrhosis Mortality
}
\description{
Calculates the Child-Pugh Score (also known as the Child-Turcotte-Pugh Score) to assess the prognosis of chronic liver disease, primarily cirrhosis. The score aggregates five clinical and laboratory measures to categorize patients into Class A, B, or C, which correlates with 1- and 2-year survival rates.
}
\usage{
child_pugh_score(bilirubin, albumin, inr, ascites, encephalopathy,
                 pbc_or_psc = 0, bilirubin_units = "mg/dL",
                 albumin_units = "g/dL")
}
\arguments{
  \item{bilirubin}{
Numeric. Total bilirubin level.
}
  \item{albumin}{
Numeric. Serum albumin level.
}
  \item{inr}{
Numeric. International Normalized Ratio (INR).
}
  \item{ascites}{
String. Degree of ascites. Options: "none" (+1 pt), "slight" (Supressed with meds, +2 pts), "moderate" (Refractory, +3 pts).
}
  \item{encephalopathy}{
String. Degree of encephalopathy. Options: "none" (+1 pt), "grade_1_2" (or medically controlled, +2 pts), "grade_3_4" (or poorly controlled, +3 pts).
}
  \item{pbc_or_psc}{
Numeric (0 or 1). Patient has Primary Biliary Cholangitis (PBC) or Primary Sclerosing Cholangitis (PSC). (1 = Yes). If Yes, modified bilirubin thresholds are used (<4, 4-10, >10 mg/dL).
}
  \item{bilirubin_units}{
String. "mg/dL" (default) or "umol/L".
}
  \item{albumin_units}{
String. "g/dL" (default) or "g/L".
}
}
\value{
A list containing:
\item{Child_Pugh_Score}{The total calculated score (Range 5-15).}
\item{Class}{The Child-Pugh Class (A, B, or C).}
\item{Life_Expectancy_1_Year}{Estimated 1-year survival rate.}
\item{Life_Expectancy_2_Year}{Estimated 2-year survival rate.}
}
\references{
Pugh RN, Murray-Lyon IM, Dawson JL, Pietroni MC, Williams R. Transection of the oesophagus for bleeding oesophageal varices. Br J Surg. 1973;60(8):646-649. doi:10.1002/bjs.1800600817
}
\examples{

# Example 1: Class A
# Bili 1.0, Alb 4.0, INR 1.0, No Ascites, No Enceph
child_pugh_score(1.0, 4.0, 1.0, "none", "none")

# Example 2: Class C
# Bili 4.0, Alb 2.0, INR 2.5, Moderate Ascites, Grade 3 Enceph
child_pugh_score(4.0, 2.0, 2.5, "moderate", "grade_3_4")
}
