\name{cerebral_perfusion_pressure}
\alias{cerebral_perfusion_pressure}
\title{
Cerebral Perfusion Pressure (CPP)
}
\description{
Calculates Cerebral Perfusion Pressure (CPP), defined as the net pressure gradient causing cerebral blood flow to the brain. It is calculated by subtracting the Intracranial Pressure (ICP) from the Mean Arterial Pressure (MAP). Maintenance of adequate CPP is critical in the management of Traumatic Brain Injury (TBI) to prevent ischemia.
}
\usage{
cerebral_perfusion_pressure(mean_arterial_pressure, intracranial_pressure)
}
\arguments{
  \item{mean_arterial_pressure}{
Numeric. The Mean Arterial Pressure (MAP) in mmHg.
}
  \item{intracranial_pressure}{
Numeric. The Intracranial Pressure (ICP) in mmHg.
}
}
\value{
A list containing:
\item{CPP_mmHg}{The calculated Cerebral Perfusion Pressure.}
\item{Interpretation}{Clinical context based on Brain Trauma Foundation guidelines (Target 60-70 mmHg).}
}
\references{
Carney N, Totten AM, O'Reilly C, et al. Guidelines for the Management of Severe Traumatic Brain Injury, Fourth Edition. Neurosurgery. 2017;80(1):6-15. doi:10.1227/NEU.0000000000001432
}
\examples{

# Example 1: Normal Target
# MAP 85, ICP 15
# CPP = 70 mmHg
cerebral_perfusion_pressure(85, 15)

# Example 2: Ischemic Risk
# MAP 60, ICP 25
# CPP = 35 mmHg
cerebral_perfusion_pressure(60, 25)
}
