\name{calculate_fena}
\alias{calculate_fena}
\title{
Fractional Excretion of Sodium (FENa)
}
\description{
Calculates the Fractional Excretion of Sodium (FENa) to help differentiate between prerenal azotemia and acute tubular necrosis (ATN) in patients with oliguric acute kidney injury.
}
\usage{
calculate_fena(serum_sodium, serum_creatinine, urine_sodium, urine_creatinine)
}
\arguments{
  \item{serum_sodium}{
Numeric. Serum Sodium level in mEq/L or mmol/L.
}
  \item{serum_creatinine}{
Numeric. Serum Creatinine level in mg/dL or umol/L (must use consistent units with urine creatinine).
}
  \item{urine_sodium}{
Numeric. Urine Sodium level in mEq/L or mmol/L.
}
  \item{urine_creatinine}{
Numeric. Urine Creatinine level in mg/dL or umol/L (must use consistent units with serum creatinine).
}
}
\value{
A list containing:
\item{FENa_Percent}{The calculated FENa percentage.}
\item{Etiology}{Interpretation (Prerenal < 1\%, Intrinsic > 2\%).}
}
\references{
Espinel CH. The FeNa test. Use in the differential diagnosis of acute renal failure. JAMA. 1976;236(16):1795-1797. doi:10.1001/jama.1976.03270170035022
}
\examples{

# Example 1: Prerenal (Dehydration)
# SNa 140, SCr 1.5, UNa 10, UCr 100
# FENa = (10 * 1.5) / (140 * 100) * 100 = 0.11%
calculate_fena(140, 1.5, 10, 100)

# Example 2: Intrinsic (ATN)
# SNa 135, SCr 2.0, UNa 40, UCr 40
# FENa = (40 * 2.0) / (135 * 40) * 100 = 1.48% (Indeterminate range, close to ATN)
calculate_fena(135, 2.0, 40, 40)
}
