\name{barthel_index_adl}
\alias{barthel_index_adl}
\title{
Barthel Index for Activities of Daily Living (ADL)
}
\description{
Calculates the Barthel Index to assess a patient's performance in activities of daily living (ADL). The index measures the degree of assistance required by an individual on 10 items of mobility and self-care. A higher score indicates greater independence.
}
\usage{
barthel_index_adl(feeding, bathing, grooming, dressing, bowels, bladder,
                  toilet_use, transfers, mobility, stairs)
}
\arguments{
  \item{feeding}{
Numeric. 0 = Unable, 5 = Needs help cutting/spreading butter, 10 = Independent.
}
  \item{bathing}{
Numeric. 0 = Dependent, 5 = Independent (or in shower).
}
  \item{grooming}{
Numeric. 0 = Needs help, 5 = Independent face/hair/teeth/shaving.
}
  \item{dressing}{
Numeric. 0 = Dependent, 5 = Needs help but can do ~50\%, 10 = Independent (including buttons/zips/laces).
}
  \item{bowels}{
Numeric. 0 = Incontinent (or needs enema), 5 = Occasional accident, 10 = Continent.
}
  \item{bladder}{
Numeric. 0 = Incontinent (or catheterized), 5 = Occasional accident, 10 = Continent.
}
  \item{toilet_use}{
Numeric. 0 = Dependent, 5 = Needs some help but can do something, 10 = Independent (on/off, dressing, wiping).
}
  \item{transfers}{
Numeric. 0 = Unable (no sitting balance), 5 = Major help (1-2 people, can sit), 10 = Minor help (verbal or physical), 15 = Independent.
}
  \item{mobility}{
Numeric. 0 = Immobile, 5 = Wheelchair independent (>50 yards), 10 = Walks with help (>50 yards), 15 = Independent (>50 yards).
}
  \item{stairs}{
Numeric. 0 = Unable, 5 = Needs help (verbal/physical), 10 = Independent.
}
}
\value{
A list containing:
\item{Barthel_Index_Score}{The calculated total score (Range 0-100).}
\item{Dependency_Level}{Interpretation of the score (Total, Severe, Moderate, Slight Dependence, or Independence).}
}
\references{
Mahoney FI, Barthel DW. Functional evaluation: the Barthel Index. Md State Med J. 1965;14:61-65.
Shah S, Vanclay F, Cooper B. Improving the sensitivity of the Barthel Index for stroke rehabilitation. J Clin Epidemiol. 1989;42(8):703-709. doi:10.1016/0895-4356(89)90065-6
}
\examples{

# Example 1: Total Dependence
# All 0s
barthel_index_adl(0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Moderate Dependence
# Feeding 10, Bathing 0, Grooming 5, Dressing 5, Bowels 10, Bladder 10,
# Toilet 5, Transfers 10, Mobility 10, Stairs 5
# Score = 70
barthel_index_adl(10, 0, 5, 5, 10, 10, 5, 10, 10, 5)
}
