\name{air_appendicitis}
\alias{air_appendicitis}
\title{
Appendicitis Inflammatory Response (AIR) Score
}
\description{
Calculates the AIR Score to predict the likelihood of acute appendicitis. Designed to outperform the Alvarado score, the AIR score incorporates objective inflammatory markers (CRP and PMN proportion) alongside clinical signs to stratify patients into low, intermediate, or high probability groups.
}
\usage{
air_appendicitis(vomiting, rlq_pain, rebound_tenderness, temp_c,
                 wbc_count, pmn_percent, crp_mg_l)
}
\arguments{
  \item{vomiting}{
Numeric (0 or 1). Presence of vomiting. (1 = Yes, +1 point).
}
  \item{rlq_pain}{
Numeric (0 or 1). Pain in the right inferior fossa. (1 = Yes, +1 point).
}
  \item{rebound_tenderness}{
Numeric (0-3). Grade of rebound tenderness or muscular defense.
0: None.
1: Light (+1 point).
2: Medium (+2 points).
3: Strong (+3 points).
}
  \item{temp_c}{
Numeric. Body temperature in Celsius. (>= 38.5 C adds +1 point).
}
  \item{wbc_count}{
Numeric. White Blood Cell count (x10^9/L).
10.0 - 14.9: +1 point.
>= 15.0: +2 points.
}
  \item{pmn_percent}{
Numeric. Proportion of polymorphonuclear leukocytes (\%).
70 - 84\%: +1 point.
>= 85\%: +2 points.
}
  \item{crp_mg_l}{
Numeric. C-Reactive Protein level (mg/L).
10 - 49: +1 point.
>= 50: +2 points.
}
}
\value{
A list containing:
\item{AIR_Score}{The calculated score (Range 0-12).}
\item{Risk_Group}{Probability grouping (Low 0-4, Indeterminate 5-8, High 9-12).}
\item{Recommendation}{Clinical management suggestion based on the Andersson et al. validation.}
}
\references{
Andersson M, Andersson RE. The appendicitis inflammatory response score: a tool for the diagnosis of acute appendicitis that outperforms the Alvarado score. World J Surg. 2008;32(8):1843-1849. doi:10.1007/s00268-008-9649-y
}
\examples{

# Example 1: High Probability
# Vomiting, RLQ pain, Strong Rebound (3), Temp 39 (1), WBC 16 (2), PMN 90\% (2), CRP 60 (2)
# Score = 1 + 1 + 3 + 1 + 2 + 2 + 2 = 12
air_appendicitis(1, 1, 3, 39, 16, 90, 60)

# Example 2: Low Probability
# RLQ pain only, Normal labs
# Score = 1
air_appendicitis(0, 1, 0, 37, 8, 60, 5)
}
