\name{age_adjusted_esr_crp}
\alias{age_adjusted_esr_crp}
\title{
Age-Adjusted ESR and CRP
}
\description{
Calculates the upper limit of normal for Erythrocyte Sedimentation Rate (ESR) and C-Reactive Protein (CRP) based on patient age and sex. Standard reference ranges often misclassify elderly patients as having elevated inflammatory markers due to the natural physiological rise of these markers with age. These formulas provide a more accurate cutoff for inflammation.
}
\usage{
age_adjusted_esr_crp(age, sex, esr = NULL, crp = NULL)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{esr}{
Numeric (Optional). Patient's measured ESR (mm/hr). If provided, the function determines if it is elevated.
}
  \item{crp}{
Numeric (Optional). Patient's measured CRP (mg/dL). If provided, the function determines if it is elevated.
}
}
\value{
A list containing:
\item{Calculated_ESR_Upper_Limit}{The age-adjusted upper limit for ESR (Formula: Male=Age/2; Female=(Age+10)/2).}
\item{Calculated_CRP_Upper_Limit}{The age-adjusted upper limit for CRP (Formula: Male=Age/50; Female=Age/50 + 0.6).}
\item{Patient_Values}{The input values provided.}
\item{Interpretation}{Status ("Normal" or "Elevated") for the provided values against the calculated limits.}
}
\references{
Miller A, Green M, Robinson D. Simple rule for calculating normal erythrocyte sedimentation rate. Br Med J (Clin Res Ed). 1983;286(6361):266.

Wener MH, Daum PR, McQuillan GM. The influence of age, sex, and race on the upper reference limit of serum C-reactive protein concentration. J Rheumatol. 2000;27(10):2351-2359.
}
\examples{

# Example 1: 70-year-old Female
# ESR Limit = (70 + 10) / 2 = 40
# CRP Limit = (70 / 50) + 0.6 = 1.4 + 0.6 = 2.0
age_adjusted_esr_crp(70, "female")

# Example 2: Evaluation of specific labs
# 60-year-old Male with ESR 25 and CRP 1.5
# ESR Limit = 30 (Normal); CRP Limit = 1.2 (Elevated)
age_adjusted_esr_crp(60, "male", esr = 25, crp = 1.5)
}
