% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{garden_club}
\alias{garden_club}
\title{Fictional "Garden Club" Pre-Post Intervention Data}
\format{
A tibble with 150 rows and 6 variables:
\describe{
\item{id}{An integer representing the unique participant identifier.}
\item{group}{A character vector indicating the treatment group (\code{"CBT"} or \code{"Antienvyssant"}).}
\item{age}{An integer representing the participant's age.}
\item{gender}{A character vector for the participant's gender (\code{"m"}, \code{"f"}, or \code{"d"}).}
\item{time}{An integer for the measurement occasion (\code{0} = pre-test, \code{1} = post-test).}
\item{gei_score}{A numeric value for the outcome, the score on the fictional Gardener Envy Inventory (GEI), ranging from 0 to 50.}
}
}
\source{
Simulated data based on a linear mixed-effects model (LMM) with fixed
effects for group and time, and random intercepts and slopes for participants.
}
\usage{
garden_club
}
\description{
A simulated dataset from a linear mixed-effects model (LMM) representing a
standard two-group (CBT vs. Antienvyssant) pre-post intervention study. The
data is ideal for demonstrating the analysis of longitudinal data with
repeated measures.
}
\seealso{
\code{\link{garden_club_sensitive}} for a dataset designed for sensitivity analysis.
}
\keyword{datasets}
