# clinPK: Clinical Pharmacokinetics Toolkit

## Overview

The clinPK package provides equations commonly used in clinical pharmacokinetics 
and clinical pharmacology, such as equations for dose individualization, 
compartmental pharmacokinetics, drug exposure, anthropomorphic calculations, 
clinical chemistry, and conversion of common clinical parameters. Where possible 
and relevant, it provides multiple published and peer-reviewed equations within 
the respective R function.

## Installation

The development version of clinPK always has the most up-to-date improvements
and bug fixes. We aim to release clinPK on CRAN at least once a year,
depending on the number and impact of updates made to the development version.

The CRAN version of clinPK can be installed using:

```
install.packages("clinPK")
```

The development version of clinPK can be installed using:

```
devtools::install_github("InsightRX/clinPK")
```

## Contributing

We welcome input from the community:

- If you think you have encountered a bug, please [submit an issue](https://github.com/InsightRX/clinPK/issues) on the GitHub 
page. Please include a reproducible example of the unexpected behavior.

- Please [open a pull request](https://github.com/InsightRX/clinPK/pulls) if you have a fix or updates that would improve the package. If you're not sure if your proposed 
changes are useful or within  scope of the package, feel free to contact one 
of the authors of this package.

## Disclaimer

The functionality in this R package is provided "as is". While its authors 
adhere to software development best practices, the software may still contain 
unintended errors.

InsightRX Inc. and the authors of this package can not be held liable for any
damages resulting from any use of this software. By the use of this software 
package, the user waives all warranties, expressed or implied, including any 
warranties to the accuracy, quality or suitability of InsightRX for any 
particular purpose, either medical or non-medical.



---

<div align="right">
© <img src="man/figures/insightrx_logo_color.png" alt="InsightRX logo" width="120" />
</div>
