% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc.R
\name{save_to}
\alias{save_to}
\alias{save_to.clc}
\title{Save a Layer and its Style to a GeoPackage or PostGIS Database}
\usage{
save_to(clo, to, database, schema, layer_name)

\method{save_to}{clc}(clo, to, database = NULL, schema = "public", layer_name = NULL)
}
\arguments{
\item{clo}{A `clc` object.}

\item{to}{A data destination for the output. This can be:
- A string representing the path to a GeoPackage file.
- A `DBI` database connection object to a PostGIS database, created using [RPostgres::dbConnect()].}

\item{database}{A string, database name, only in case the destination is in PostGIS.}

\item{schema}{A string, schema name, only in case the destination is in PostGIS.
Defaults to `'public'`.}

\item{layer_name}{A character string specifying the name of the layer in the output.
If `NULL`, the name of the input `layer` is used.}
}
\value{
clo A `clc` object.
}
\description{
This function saves a layer and its style to a GeoPackage file or a PostGIS database.
The destination is determined by the `to` argument.
}
\details{
The function overwrites the table if it already exists.
}
\examples{
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
clo <- clc(source = source_gpkg, layer_name = "clc")

# ex1
out_gpkg <- tempfile(fileext = ".gpkg")

sink(tempfile())
clo <- clo |>
  save_to(out_gpkg)
sink()

\dontrun{
# ex2
conn <- RPostgres::dbConnect(
  RPostgres::Postgres(),
  dbname = 'exampledb',
  host = 'localhost',
  port = '5432',
  user = 'user',
  password = 'password'
)
clo <- clo |>
  save_to(conn, 'exampledb')
}
}
\seealso{
Other CLC class functions: 
\code{\link{as_raster}()},
\code{\link{clc}()},
\code{\link{copy_to}()},
\code{\link{cut_to_extent}()},
\code{\link{get_colors.clc}()},
\code{\link{get_levels.clc}()},
\code{\link{get_raster}()},
\code{\link{plot_clc}()},
\code{\link{prepare_plot}()}
}
\concept{CLC class functions}
