% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc.R
\name{cut_to_extent}
\alias{cut_to_extent}
\alias{cut_to_extent.clc}
\title{Clip the Layer with a Polygon}
\usage{
cut_to_extent(clo, polygon)

\method{cut_to_extent}{clc}(clo, polygon)
}
\arguments{
\item{clo}{A `clc` object.}

\item{polygon}{An `sf` object representing the polygon layer used for clipping.}
}
\value{
A `clc` object.
}
\description{
This function clips the object layer using a polygon layer. It handles CRS
transformations automatically if necessary, ensuring the output is in the same
CRS as the input polygon.
}
\examples{
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
clo <- clc(source = source_gpkg, layer_name = "clc")

polygon <- sf::st_read(source_gpkg, layer = 'lanjaron', quiet = TRUE)

clo2 <- clo |>
        cut_to_extent(polygon)

}
\seealso{
Other CLC class functions: 
\code{\link{as_raster}()},
\code{\link{clc}()},
\code{\link{copy_to}()},
\code{\link{get_colors.clc}()},
\code{\link{get_levels.clc}()},
\code{\link{get_raster}()},
\code{\link{plot_clc}()},
\code{\link{prepare_plot}()},
\code{\link{save_to}()}
}
\concept{CLC class functions}
