% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwTs.R
\name{bwTs}
\alias{bwTs}
\title{Plug-in Method by Tsuruta and Sagae with multiplicative method from Terrell and Scott}
\usage{
bwTs(x, verbose = FALSE)
}
\arguments{
\item{x}{Data from which the smoothing parameter is to be computed. The object is
coerced to a numeric vector in radians using \code{\link[circular]{conversion.circular}}.
Can be a numeric vector or an object of class \code{circular}.}

\item{verbose}{Logical indicating whether to print intermediate computational values
for debugging purposes. Useful for diagnosing floating-point instability in
Bessel-based moment terms. Default is FALSE.}
}
\value{
The computed optimal smoothing parameter, a numeric value derived from
the circular version of the multiplicative method for circular kernel density estimation.
}
\description{
This function computes the optimal smoothing parameter (bandwidth) for circular data
using the plug-in method, introduced by Tsuruta and Sagae (see \doi{10.1016/j.spl.2017.08.003}) with the
multiplicative method from Terrell and Scott (1980) to form higher-order kernel functions.
The method optimally balances the bias-variance tradeoff by minimizing asymptotic mean
integrated squared error.
}
\details{
The plug-in approach estimates the optimal bandwidth through the following steps:
\enumerate{
\item Apply the multiplicative method from Terrell and Scott (1980) to construct a p-th order kernel function.
\item Derive expression for asymptotic mean integrated squared error (AMISE) expression.
\item Solving for the bandwidth that minimizes the AMISE. The optimal
bandwidth for the multiplicative Terrell-Scott method is given by:
\deqn{\hat{\kappa}_{TS} = \left[\frac{288}{33 - 16\sqrt{2/5}} \hat{R}_{\hat{\tau}}(m_{VM}) n\right]^{2/9}}
where the computational formula is:
\deqn{m_{VM}(\theta) := [2\{f_{VM}^{(2)}\}^2/f_{VM} - 5f_{VM}^{(2)} + 2f_{VM}^{(4)}]/4}
and \eqn{\hat{R}_{\hat{\tau}}(m_{VM})} is the functional computed under the von Mises assumption
using the multiplicative approach. The parameter \eqn{\hat{\tau}} is the MLE estimate of the
von Mises concentration parameter used as the initial value.
}
}
\examples{
# Example with circular data
library(circular)
set.seed(123)
x <- rvonmises(100, mu = circular(0), kappa = 2)
bw <- bwTs(x)
print(bw)

x <- rwrappednormal(100, mu = circular(1), rho = 0.7)
x <- as.numeric(x)
bw <- bwTs(x)
print(bw)

}
\references{
Tsuruta, Yasuhito & Sagae, Masahiko (2017). Higher order kernel density
estimation on the circle. \emph{Statistics & Probability Letters}, 131:46--50.
\doi{10.1016/j.spl.2017.08.003}

Terrell, George R. & Scott, David W. (1980). On improving convergence rates
for nonnegative kernel density estimators. \emph{The Annals of Statistics},
8(5):1160--1163.
}
\seealso{
\link{bwScv}, \link{bwLscvg}, \link{bwCcv}
}
