% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccGenomicLines}
\alias{ccGenomicLines}
\title{Add lines for genomic data visualization}
\usage{
ccGenomicLines(
  region = NULL,
  value = NULL,
  numeric.column = NULL,
  posTransform = NULL,
  col = ifelse(area, "grey", "black"),
  lwd = par("lwd"),
  lty = par("lty"),
  type = "l",
  area = FALSE,
  area.baseline = NULL,
  border = "black",
  baseline = "bottom",
  pt.col = par("col"),
  cex = par("cex"),
  pch = par("pch"),
  ...
)
}
\arguments{
\item{region}{A data frame contains 2 column which correspond to start positions and end positions.
}

\item{value}{A data frame contains values and other information.
}

\item{numeric.column}{Which column in \code{value} data frame should be taken as y-value.
 If it is not defined, the whole numeric columns in \code{value} will be taken.
}

\item{posTransform}{Self-defined function to transform genomic positions, see \code{\link[circlize]{posTransform.default}} for explaination.
}

\item{col}{col of lines/areas. If there are more than one numeric column, the length of \code{col} can be either one or number of numeric columns.
 If there is only one numeric column and type is either \code{segment} or \code{h}, 
 the length of \code{col} can be either one or number of rows of \code{region}.
 pass to \code{\link[circlize]{circos.lines}}
}

\item{lwd}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}.
}

\item{lty}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}.
}

\item{type}{There is an additional option \code{segment} which plot segment lines from start position to end position. Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}. 
}

\item{area}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}.
}

\item{area.baseline}{Deprecated, use \code{baseline} instead.
}

\item{border}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}.
}

\item{baseline}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}.
}

\item{pt.col}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}.
}

\item{cex}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}.
}

\item{pch}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.lines}}.
}

\item{...}{Mysterious parameters.
}
}
\value{
Object \linkS4class{ccGenomicCellGeom}
}
\description{
Object \linkS4class{ccGenomicCellGeom} will call the function \link[circlize:circos.genomicLines]{circlize::circos.genomicLines} while drawing.
}
\examples{
library(circlizePlus)
data <- generateRandomBed(nr = 30, nc = 2)
all_chr <- c("chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8",
"chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16",
"chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY")
cc <- ccPlot(initMode = "initializeWithIdeogram", plotType = NULL)
t1 <- ccGenomicTrack(data = data, numeric.column = 4)
cells1 <- ccCells(sector.indexes = all_chr) +
ccGenomicLines(numeric.column = 2)
t1 <- t1 + cells1
show(cc + t1)
}
