% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{weighted_sem}
\alias{weighted_sem}
\title{Weighted standard error of the mean (SEM_w)}
\usage{
weighted_sem(x, w, na.rm = FALSE)
}
\arguments{
\item{x}{variable to compute the SEM for}

\item{w}{weights}

\item{na.rm}{should NAs be removed}
}
\value{
weighted standard error of the mean
}
\description{
Computes the variance of a weighted mean following the definitions given by Kirchner (2006).
}
\details{
James Kirchner describes two different cases when the weighted variance is computed. The code here implements Case I where "one wants to give more weight to some points than to others, because they are considered to be more important" and "the weights differ but the uncertainties associated with the individual xi are assumed to be the same" (Kirchner, 2006, p. 1). The formula used is:
\mjsdeqn{SEM_w = \sqrt{\left(\sum_{i = 1}^{N} (w_{i} x_i^2)-\bar{x}^2\right)\frac{\sum_{i = 1}^{N} w_i^2}{1-\sum_{i = 1}^{N} w_i^2}} }
The expected error is within 5\% of the bootstrapped SEM (at larger sample sizes).
}
\examples{
set.seed(1)
n_obs <- 200
w <- runif(n_obs)
w <- w/sum(w)
x <- rnorm(n_obs, sd = 5)
weighted_sem(x, w)
}
\references{
{
\itemize{
\item Kirchner, J. 2006. Data Analysis Toolkit #12: Weighted averages and their uncertainties. \url{https://seismo.berkeley.edu/~kirchner/Toolkits/Toolkit_12.pdf}.  Retrieved on 04.07.2024.
\item Bevington, P. R. 1969. Data Reduction and Error Analysis for the Physical Sciences. McGraw-Hill, 336 pp.

}
}
}
