% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_named_map.R
\name{parse_named_map}
\alias{parse_named_map}
\alias{get_named_map}
\title{Parse Named Map from CIFTI}
\usage{
parse_named_map(nodeset)

get_named_map(fname, verbose = TRUE)
}
\arguments{
\item{nodeset}{Set of XML nodes corresponding to \code{NamedMap}}

\item{fname}{filename of CIFTI file}

\item{verbose}{print diagnostic messages}
}
\value{
List of values
}
\description{
Extracts information about Named Maps from CIFTI file
}
\examples{
\dontrun{
doc = cifti_xml(fname)
nodes = xml_find_all(doc, "/CIFTI/Matrix/MatrixIndicesMap")
nodeset = xml_find_all(nodes, "./NamedMap")
parse_named_map(nodeset)
}
}
