% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_chains.R
\name{[.cia_post_chains}
\alias{[.cia_post_chains}
\title{Index a cia_post_chains object with respect to iterations.}
\usage{
\method{[}{cia_post_chains}(x = list(), i, ...)
}
\arguments{
\item{x}{A cia_post_chain object.}

\item{i}{An index to get the cia_post_chain iterations.}

\item{...}{ellipsis for extra indexing parameters.}
}
\value{
chain A cia_post_chains object.
}
\description{
Index a cia_post_chains object with respect to iterations.
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

results <- SampleChains(10, partitioned_nodes, PartitionMCMC(), scorer)
dag_chains <- PartitiontoDAG(results, scorer)

pedge_sample <- SampleEdgeProbabilities(dag_chains)
pedge_sample[5, ]

}
