% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ci_multinom}
\alias{ci_multinom}
\title{Proportion CI: Multinomial Variable (3 or more groups)}
\usage{
ci_multinom(
  x,
  method = "goodman",
  conf.level = 0.95,
  gr_colname = "group",
  ...
)
}
\arguments{
\item{x}{Vector of group sizes. Best if elements have meaningful names
(see examples).}

\item{method}{Calculation method: \code{"goodman"}, \code{"sisonglaz"}, \code{"cplus1"}, and others.
See \code{\link[DescTools:MultinomCI]{DescTools::MultinomCI()}} documentation.}

\item{conf.level}{Confidence level. Default: 0.95.}

\item{gr_colname}{Column name (quoted) for group names. Default: \code{"group"}.}

\item{...}{Additional parameters for \code{\link[DescTools:MultinomCI]{DescTools::MultinomCI()}}.}
}
\value{
A data frame with columns:
\itemize{
\item \code{group} or user-specified name (\verb{<fct>}) -- group names;
\item \code{est} (\verb{<dbl>}) -- proportion estimate;
\item \code{lwr.ci}, \code{upr.ci} (\verb{<dbl>}) -- lower and upper CI bounds;
\item \code{x} (\verb{<int>}) -- group size;
\item \code{n} (\verb{<int>}) -- total number of events.
}
}
\description{
Calculates simultaneous confidence intervals (CI) for proportions in
multinomial variables (k >= 3). This enhanced version of \code{\link[DescTools:MultinomCI]{DescTools::MultinomCI()}}
returns a data frame.
}
\details{
Similar to \code{\link[DescTools:MultinomCI]{DescTools::MultinomCI()}}, but uses the Goodman method by default
and returns a data frame, enabling convenient plotting with \pkg{ggplot2}.
}
\examples{
# Example 1: Student grade distribution
# A: 20 students, B: 35 students, C: 25 students, D/F: 15 students
grades <- c("A" = 20, "B" = 35, "C" = 25, "D/F" = 15)
ci_multinom(grades)
# Each row shows the CI for that grade's proportion

# Example 2: Transportation preferences
transport <- c("Car" = 45, "Bus" = 30, "Bike" = 15, "Walk" = 20)
ci_multinom(transport)

# Example 3: Blood type distribution
blood_types <- c("O" = 156, "A" = 134, "B" = 38, "AB" = 22)
ci_multinom(blood_types)

# Example 4: Political party preference
parties <- c("Party A" = 380, "Party B" = 420, "Party C" = 200)
ci_multinom(parties)

# Unnamed frequencies (groups will be numbered)
ci_multinom(c(20, 35, 54))

# Using pipe operator
c("Small" = 20, "Medium" = 35, "Large" = 54) |>
  ci_multinom()

# Different method for simultaneous intervals
c("Small" = 33, "Medium" = 35, "Large" = 30) |>
  ci_multinom(method = "sisonglaz")

# Custom column name for groups
c("Dog" = 65, "Cat" = 48, "Bird" = 22, "Other" = 15) |>
  ci_multinom(gr_colname = "pet_type")

# Example 5: Teaching method effectiveness
# Outcome categories: Poor, Fair, Good, Excellent
outcomes <- c("Poor" = 8, "Fair" = 22, "Good" = 45, "Excellent" = 35)
ci_multinom(outcomes)
# Look for non-overlapping CIs to identify categories that differ significantly

}
