## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----parsermd-chunk-1---------------------------------------------------------
library(chronicler)
library(dplyr)
library(tidyr)
library(lubridate)

data("avia")

## ----parsermd-chunk-2---------------------------------------------------------
# Define required functions
# You can use `record_many()` to avoid having to write everything

r_select <- record(select, .g = dim)
r_pivot_longer <- record(pivot_longer, .g = dim)
r_filter <- record(filter, .g = dim)
r_separate <- record(separate, .g = dim)
r_group_by <- record(group_by, .g = dim)
r_summarise <- record(summarise, .g = dim)


## ----parsermd-chunk-3---------------------------------------------------------
avia_clean <- avia %>%
  r_select(1, contains("20")) %>% # select the first column and every column starting with 20
  bind_record(r_pivot_longer,
              -starts_with("freq"),
              names_to = "date",
              values_to = "passengers") %>%
  bind_record(r_separate,
              col = 1,
              into = c("freq", "unit", "tra_meas", "air_pr\\time"),
              sep = ",")

## ----parsermd-chunk-4---------------------------------------------------------
avia_clean

## ----parsermd-chunk-5---------------------------------------------------------
r_mutate <- record(mutate, .g = dim)

avia_clean2 <- avia_clean %>%
  bind_record(r_mutate,
              passengers = as.numeric(passengers))

## ----parsermd-chunk-6---------------------------------------------------------
avia_clean2

## ----parsermd-chunk-7---------------------------------------------------------
read_log(avia_clean2)

## ----parsermd-chunk-8---------------------------------------------------------
r_mutate_lenient <- record(mutate, .g = dim, strict = 1)

avia_clean2 <- avia_clean %>%
  bind_record(r_mutate_lenient,
              passengers = as.numeric(passengers)
              )


## ----parsermd-chunk-9---------------------------------------------------------
avia_clean2

## ----parsermd-chunk-10--------------------------------------------------------
avia_monthly <- avia_clean2 %>%
  bind_record(r_filter,
              freq == "M",
              tra_meas == "PAS_BRD_ARR",
              !is.na(passengers)) %>%
  bind_record(r_mutate,
              date = paste0(date, "01"),
              date = ymd(date)) %>%
  bind_record(r_select,
              destination = "air_pr\\time", date, passengers)


## ----parsermd-chunk-11--------------------------------------------------------
fmap_record(avia_monthly, count, date)

## ----parsermd-chunk-12--------------------------------------------------------
avia_monthly

## ----parsermd-chunk-13--------------------------------------------------------
read_log(avia_monthly)

## ----parsermd-chunk-14--------------------------------------------------------
avia_monthly %>%
  unveil("value")

## ----parsermd-chunk-15--------------------------------------------------------
check_g(avia_monthly)

## ----parsermd-chunk-16, include = FALSE---------------------------------------
hu <- check_g(avia_monthly)$g

