% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/images.R
\name{add_image}
\alias{add_image}
\title{Add an image to a chronicle Rmarkdown report}
\usage{
add_image(
  report = "",
  image_path,
  image_caption = NULL,
  image_title = NULL,
  title_level = 2,
  fig_width = NULL,
  fig_height = NULL
)
}
\arguments{
\item{report}{Character string containing all the R Markdown chunks previously added. Default is '', an empty report.}

\item{image_path}{The path to the image that will be added to the report.}

\item{image_caption}{A caption to be printed for the image.}

\item{image_title}{The title of the text section. Default is NULL.}

\item{title_level}{Level of the section title of this text (ie, number of # on Rmarkdown syntax.)}

\item{fig_width}{Width of the figures printed from this code.}

\item{fig_height}{Height of the figures printed from this code.}
}
\value{
The text of the Rmarkdown report plus an additional section with the text.
}
\description{
Add an image to a chronicle Rmarkdown report
}
\examples{

library(chronicle)
report <- add_image(image_path = 'readme1.png',
                    image_caption = 'This is the caption of the image',
                    image_title = 'This is the image that I want to include')
}
