% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mzml.R
\name{read_mzml}
\alias{read_mzml}
\title{Read mzML files}
\usage{
read_mzml(
  path,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("long", "wide"),
  parser = c("RaMS", "mzR"),
  what = c("MS1", "MS2", "BPC", "TIC", "DAD", "chroms", "metadata", "everything"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{path}{Path to \code{.mzml} file.}

\item{format_out}{Class of output. Only applies if \code{mzR} is selected.
Either \code{matrix}, \code{data.frame}, or \code{data.table}. \code{RaMS}
will return a list of data.tables regardless of what is selected here.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{parser}{What parser to use. Either \code{RaMS} or \code{mzR}.}

\item{what}{What types of data to return (argument to \code{\link[RaMS]{grabMSdata}}.
Options include \code{MS1}, \code{MS2}, \code{BPC}, \code{TIC}, \code{DAD},
\code{chroms}, \code{metadata}, or \code{everything}).}

\item{verbose}{Argument to \code{\link[RaMS]{grabMSdata}} controlling \code{verbosity}.}

\item{...}{Additional arguments to \code{\link[RaMS]{grabMSdata}}.}
}
\value{
If \code{RaMS} is selected, the function will return a list of "tidy"
\code{data.table} objects. If \code{mzR} is selected, the function will return a
chromatogram in \code{matrix} or \code{data.frame} format according to the
value of \code{format_out}.
}
\description{
Extracts data from \code{mzML} files using parsers from either RaMS or mzR.
The RaMS parser (default) will only return data in tidy (long) format. The
mzR parser will return data in wide format. Currently the mzR-based parser
is configured to return only DAD data.
}
\author{
Ethan Bass
}
