% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chemstation_uv.R
\name{read_chemstation_uv}
\alias{read_chemstation_uv}
\title{Read 'Agilent ChemStation' DAD files}
\usage{
read_chemstation_uv(
  path,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw"),
  scale = TRUE
)
}
\arguments{
\item{path}{Path to 'Agilent' \code{.uv} file.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Either \code{wide} (default) or \code{long}.}

\item{read_metadata}{Logical. Whether to attach metadata. Defaults to \code{TRUE}.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{scale}{Whether to scale the data by the scaling factor present in the
file. Defaults to \code{TRUE}.}
}
\value{
A 3D chromatogram in the format specified by \code{data_format} and
\code{format_out}. If \code{data_format} is \code{wide}, the chromatogram will
be returned with retention times as rows and wavelengths as columns. If
\code{long} format is requested, three columns will be returned: one for the
retention time, one for the wavelength and one for the intensity. The
\code{format_out} argument determines whether the chromatogram is returned as
a \code{matrix} or \code{data.frame}. Metadata can be attached to the
chromatogram as \code{\link{attributes}} if \code{read_metadata} is \code{TRUE}.
}
\description{
Agilent \code{.uv} files come in several different formats. This parser can
automatically detect and read several versions of these files from
'Agilent ChemStation' and 'Agilent OpenLab', including versions \code{31} and
\code{131}.
}
\note{
This function was adapted from the parser in the rainbow project
licensed under GPL 3 by Evan Shi
\url{https://rainbow-api.readthedocs.io/en/latest/agilent/uv.html}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
read_chemstation_uv("tests/testthat/testdata/dad1.uv")
\dontshow{\}) # examplesIf}
}
\seealso{
Other 'Agilent' parsers: 
\code{\link{read_agilent_d}()},
\code{\link{read_agilent_dx}()},
\code{\link{read_chemstation_ch}()},
\code{\link{read_chemstation_csv}()},
\code{\link{read_chemstation_ms}()},
\code{\link{read_chemstation_reports}()}
}
\author{
Ethan Bass
}
\concept{'Agilent' parsers}
