% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cdf.R
\name{read_cdf}
\alias{read_cdf}
\title{Read CDF}
\usage{
read_cdf(
  path,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  what = NULL,
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw"),
  collapse = TRUE,
  ...
)
}
\arguments{
\item{path}{Path to ANDI netCDF file.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{\link[data.table]{data.table}}.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.
For 2D files, "long" format returns the retention time as the first column of
the data.frame or matrix while "wide" format returns the retention time as the
rownames of the object.}

\item{what}{For ANDI chrom files, whether to extract \code{chroms}
and/or \code{peak_table}. For ANDI ms files, whether to extract MS1 scans
(\code{MS1}) or the total ion chromatogram (\code{TIC}).}

\item{read_metadata}{Whether to read metadata from file.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{collapse}{Logical. Whether to collapse lists that only contain a single
element.}

\item{...}{Additional arguments to parser. The \code{ms_format} argument
can be used here to specify whether to return mass spectra in \code{list}
format or as a \code{data.frame}.}
}
\value{
A chromatogram in the format specified by the \code{format_out} and
\code{data_format} arguments.
}
\description{
Reads 'Analytical Data Interchange' (ANDI) netCDF (\code{.cdf}) files.
}
\author{
Ethan Bass
}
