% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_euclidean.R
\name{distance_euclidean}
\alias{distance_euclidean}
\title{Compute the pairwise Euclidean distance}
\usage{
distance_euclidean(sites, ...)
}
\arguments{
\item{sites}{an \code{sf} object of type \code{POINT}. A spatial object
containing coordinates of sites. Note that the first column must be the
node label created by the function \code{\link[=create_node_labels]{create_node_labels()}}.}

\item{...}{other argument to pass to \code{\link[sf:geos_measures]{sf::st_distance()}}.}
}
\value{
A three-column \code{data.frame} with:
\itemize{
\item \code{from}, the first node
\item \code{to}, the second node
\item \code{weight}, the Euclidean distance between the two nodes
}
}
\description{
Computes the Euclidean distance between two nodes using the function
\code{\link[sf:geos_measures]{sf::st_distance()}}. If the CRS is not a Cartesian system, the Great Circle
distance will be used instead.
}
\examples{
# Import Adour sites ----
path_to_file <- system.file("extdata", "adour_survey_sampling.csv", 
                            package = "chessboard")
adour_sites <- read.csv(path_to_file)

# Select the 15 first sites ----
adour_sites <- adour_sites[1:15, ]

# Create node labels ----
adour_sites <- create_node_labels(adour_sites, 
                                  location = "location", 
                                  transect = "transect", 
                                  quadrat  = "quadrat")

# Convert sites to sf object (POINTS) ----
adour_sites <- sf::st_as_sf(adour_sites, coords = c("longitude", "latitude"),
                            crs = "epsg:2154")

# Compute distances between pairs of sites ----
weights <- distance_euclidean(adour_sites)

head(weights)
}
