% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectivity_matrix.R
\name{connectivity_matrix}
\alias{connectivity_matrix}
\title{Create a connectivity matrix from an edge list}
\usage{
connectivity_matrix(
  edges,
  lower = TRUE,
  upper = TRUE,
  diag = TRUE,
  na_to_zero = TRUE
)
}
\arguments{
\item{edges}{a \code{data.frame} with the following two columns: \code{from} (the
first node of the edge) and \code{to} (the second node of the edge). The output
of the functions \code{\link[=create_edge_list]{create_edge_list()}} or \code{\link[=append_edge_lists]{append_edge_lists()}}.}

\item{lower}{a \code{logical} value. If \code{TRUE} (default), keep values in the
lower triangle of the matrix. Otherwise they will be replaced by \code{NA}
(or \code{0}).}

\item{upper}{a \code{logical} value. If \code{TRUE} (default), keep values in the
upper triangle of the matrix. Otherwise they will be replaced by \code{NA}
(or \code{0}).}

\item{diag}{a \code{logical} value. If \code{TRUE} (default), keep values in the
diagonal of the matrix. Otherwise they will be replaced by \code{NA}
(or \code{0}).}

\item{na_to_zero}{a \code{logical} value. If \code{TRUE} (default), missing edges are
coded as \code{0}. Otherwise they will be coded as \code{NA}.}
}
\value{
A connectivity matrix of dimensions \verb{n x n}, where \code{n} is the number
of nodes.
}
\description{
Converts an edge list to an connectivity matrix (also known as adjacency
matrix).
}
\examples{
# Import Adour sites ----
path_to_file <- system.file("extdata", "adour_survey_sampling.csv", 
                            package = "chessboard")
adour_sites  <- read.csv(path_to_file)

# Select first location ----
adour_sites <- adour_sites[adour_sites$"location" == 1, ]

# Create node labels ----
adour_nodes <- create_node_labels(data     = adour_sites, 
                                  location = "location", 
                                  transect = "transect", 
                                  quadrat = "quadrat")

# Find edges with 1 degree of neighborhood (pawn method) ----
adour_edges <- create_edge_list(adour_nodes, method = "pawn", 
                                directed = TRUE)

# Get connectivity matrix ----
connectivity_matrix(adour_edges)

# Get connectivity matrix ----
connectivity_matrix(adour_edges, na_to_zero = FALSE)
}
