% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_matrix.R
\name{append_matrix}
\alias{append_matrix}
\title{Combine several connectivity matrices}
\usage{
append_matrix(..., na_to_zero = TRUE)
}
\arguments{
\item{...}{one or several \code{matrix} objects created by
\code{\link[=connectivity_matrix]{connectivity_matrix()}}.}

\item{na_to_zero}{a \code{logical} value. If \code{TRUE} (default) missing edges are
coded as \code{0}. Otherwise they will be coded as \code{NA}.}
}
\value{
A connectivity matrix of dimensions \verb{n x n}, where \code{n} is the total
number of unique nodes across all provided matrices.
}
\description{
Combines different connectivity matrices by row names and column names by
performing a 2-dimensional full join. Missing edges are filled with \code{0}
(default) or \code{NA} (argument \code{na_to_zero}).
}
\examples{
mat1 <- matrix(rep(1, 9), nrow = 3)
colnames(mat1) <- c("A", "B", "C")
rownames(mat1) <- c("A", "B", "C")
mat1

mat2 <- matrix(rep(1, 9), nrow = 3)
colnames(mat2) <- c("D", "E", "F")
rownames(mat2) <- c("D", "E", "F")
mat2

mat3 <- matrix(rep(1, 9), nrow = 3)
colnames(mat3) <- c("F", "G", "H")
rownames(mat3) <- c("F", "G", "H")
mat3

append_matrix(mat1, mat2, mat3)

append_matrix(mat1, mat2, mat3, na_to_zero = FALSE)
}
