% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_ord}
\alias{plot_ord}
\title{Plot of phase space and kinetic curve}
\usage{
plot_ord(ord_res)
}
\arguments{
\item{ord_res}{an 'ord_res' object}
}
\value{
Two plots. The first representing the transformed data in the phase
space and the other the kinetic data in the conventional space along with
their regression curves.
Black line represent the best regression curve, whereas green lines show the
fits with the reaction order chosen.
}
\description{
The function plots the results obtained from a \code{\link[=det_order]{det_order()}} function.
Two plots are shown: one representing the transformed data in the phase
space and the other the kinetic data in the conventional space along with
their regression curves.
}
\examples{
t <- c(0, 4, 8, 12, 16, 20)
conc <- c(1, 0.51, 0.24, 0.12, 0.07, 0.02)
dframe <- data.frame(t, conc)
res <- det_order(dframe)

plot_ord(res)
}
