% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-typechecks.R
\name{is_count}
\alias{is_count}
\title{Check if a Numeric Value is a Count}
\usage{
is_count(x, include_zero = TRUE)
}
\arguments{
\item{x}{Numeric value to check.}

\item{include_zero}{Logical, whether to include zero as a valid count.}
}
\value{
\code{TRUE} if \code{x} is a count, otherwise \code{FALSE}.
}
\description{
This function checks if a numeric value is a count, meaning it is
integer-like and non-negative.
}
\examples{
is_count(0) # TRUE
is_count(3) # TRUE
is_count(0, include_zero = FALSE) # FALSE
is_count(-1) # FALSE
is_count(1.5) # FALSE
}
\seealso{
\code{\link{is_proportion}}, \code{\link{is_integerlike}},
\code{\link{validate_count}}, \code{\link{validate_proportion}}
}
