% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartreview.r
\name{fullrun}
\alias{fullrun}
\title{Adaptive sampling algorithm which implements several types of sampling strategies}
\usage{
fullrun(
  dat1,
  S,
  dat2,
  mode = 1,
  batchsize = 100,
  raking = TRUE,
  rakingmode = 3,
  rakingthreshold = 0.05,
  sdEstimate = mad,
  minSamples = 10
)
}
\arguments{
\item{dat1}{First dataset on which the strata are computed.}

\item{S}{Matrix defining the strata.}

\item{dat2}{Second dataset on which confidence intervals are computed.}

\item{mode}{Sampling mode (1 for random sampling, 2 for stratified random sampling, 3 for Neyman's sampling).}

\item{batchsize}{Batch size in each wave.}

\item{raking}{Boolean flag to switch on raking.}

\item{rakingmode}{Option for raking (1 for random sampling, 2 for deterministic allocation, 3 for residual resampling).}

\item{rakingthreshold}{Threshold for applying raking to a stratum.}

\item{sdEstimate}{The estimate of the standard deviation as a function handle (usually sd or mad).}

\item{minSamples}{Minimum number of samples used in each iteration.}
}
\value{
List with the resampled datasets per wave.
}
\description{
Adaptive sampling algorithm which implements several types of sampling strategies
}
\examples{
require(chartreview)

}
\references{
.
}
