% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{glm}
\alias{glm}
\alias{glm.nb}
\title{Loglikelihood adjustments for glm fits}
\description{
In a generalised linear model (glm), the user can choose between a range of
distributions of a response \eqn{y}, and can allow for non-linear relations
between the mean outcome for a particular combination of covariates \eqn{x},
\eqn{E(y_i\mid x_i)=\mu_i}, and the linear predictor,
\eqn{\eta_i=x_i^T\beta}, which is the link function \eqn{g(\mu_i)=\eta_i}.
it is required to be monotonic. (For a quick introduction, see
Kleiber and Zeileis (2008, Ch. 5.1), for more complete coverage of the
topic, see, for example, Davison (2003, Ch. 10.3))
}
\details{
For more usage examples and more information on \code{glm} models, see the
\emph{Introducing \code{chantrics}} vignette by running
\code{vignette("chantrics-vignette", package = "chantrics")}
}
\section{Supported families (within each family, any link function should work)}{

\itemize{
\item \code{gaussian}
\item \code{poisson}
\item \code{binomial}
\item \code{MASS::negative.binomial}
}

Also works for \code{\link[MASS:glm.nb]{MASS::glm.nb()}}, note that the standard errors of the theta
are not adjusted.
}

\examples{
# binomial example from Applied Econometrics in R, Kleiber/Zeileis (2008)
# ==  probit  ==
data("SwissLabor", package = "AER")
swiss_probit <- glm(participation ~ . + I(age^2),
  data = SwissLabor,
  family = binomial(link = "probit")
)
summary(swiss_probit)
swiss_probit_adj <- adj_loglik(swiss_probit)
summary(swiss_probit_adj)

# == logit ==
swiss_logit <- glm(participation ~ . + I(age^2),
  data = SwissLabor,
  family = binomial(link = "logit")
)
summary(swiss_logit)
swiss_logit_adj <- adj_loglik(swiss_logit)
summary(swiss_logit_adj)
}
\references{
Davison, A. C. 2003. Statistical Models. Cambridge Series on
Statistical and Probabilistic Mathematics 11. Cambridge University Press,
Cambridge.

Kleiber, Christian, and Achim
Zeileis. 2008. Applied Econometrics with R. Edited by Robert Gentleman,
Kurt Hornik, and Giovanni Parmigiani. Use r! New York: Springer-Verlag.
}
