% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmguru-functions-docs.R
\name{find_max_before_hours}
\alias{find_max_before_hours}
\title{Find Maximum Glucose Before Specified Hours}
\usage{
find_max_before_hours(df, start_point_df, hours)
}
\arguments{
\item{df}{A dataframe containing continuous glucose monitoring (CGM) data.
Must include columns:
\itemize{
  \item \code{id}: Subject identifier (string or factor)
  \item \code{time}: Time of measurement (POSIXct)
  \item \code{gl}: Glucose value (integer or numeric, mg/dL)
}}

\item{start_point_df}{A dataframe with column \code{start_indices} (R-based indices into \code{df})}

\item{hours}{Number of hours to look back from the start point}
}
\value{
A list containing:
\itemize{
  \item \code{max_indices}: Tibble with R-based (1-indexed) row numbers of maximum glucose (\code{max_indices}).
    The corresponding occurrence time is \code{df$time[max_indices]} and glucose is \code{df$gl[max_indices]}.
  \item \code{episode_counts}: Tibble with episode counts per subject (\code{id}, \code{episode_counts})
  \item \code{episode_start}: Tibble with all episode starts with columns:
    \itemize{
      \item \code{id}: Subject identifier
      \item \code{time}: Timestamp at which the maximum occurs; equivalent to \code{df$time[indices]}
      \item \code{gl}: Glucose value at the maximum; equivalent to \code{df$gl[indices]}
      \item \code{indices}: R-based (1-indexed) row number(s) in \code{df} denoting where the maximum occurs
    }
}
}
\description{
Identifies the maximum glucose value occurring within a specified time window
before a given start point. This function is useful for analyzing glucose
patterns preceding specific events or time points.
}
\section{Notes}{

- The search window is [\code{hours}, 0) hours before each start index.
}

\examples{
# Load sample data
library(iglu)
data(example_data_5_subject)
data(example_data_hall)

# Create start points for demonstration (using row indices)
start_indices <- seq(1, nrow(example_data_5_subject), by = 100)
start_points <- data.frame(start_indices = start_indices)

# Find maximum glucose in previous 2 hours
max_before <- find_max_before_hours(example_data_5_subject, start_points, hours = 2)
print(paste("Found", length(max_before$max_indices), "maximum points"))

# Find maximum glucose in previous 1 hour
max_before_1h <- find_max_before_hours(example_data_5_subject, start_points, hours = 1)

# Analysis on larger dataset
large_start_indices <- seq(1, nrow(example_data_hall), by = 200)
large_start_points <- data.frame(start_indices = large_start_indices)
large_max_before <- find_max_before_hours(example_data_hall, large_start_points, hours = 2)
print(paste("Found", length(large_max_before$max_indices), "maximum points in larger dataset"))
}
\seealso{
\link{mod_grid}, \link{find_local_maxima}, \link{find_new_maxima}

Other GRID pipeline: 
\code{\link{detect_between_maxima}()},
\code{\link{find_local_maxima}()},
\code{\link{find_max_after_hours}()},
\code{\link{find_min_after_hours}()},
\code{\link{find_min_before_hours}()},
\code{\link{find_new_maxima}()},
\code{\link{grid}()},
\code{\link{maxima_grid}()},
\code{\link{mod_grid}()},
\code{\link{start_finder}()},
\code{\link{transform_df}()}
}
\concept{GRID pipeline}
