% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cforward.R
\name{estimate_concordance}
\alias{estimate_concordance}
\title{Estimate Out-of-Sample Concordance}
\usage{
estimate_concordance(
  train,
  test = train,
  event_time = "event_time_years",
  event_status = "mortstat",
  weight_column = "WTMEC4YR_norm",
  all_variables = NULL,
  cfit_args = list(),
  ...
)
}
\arguments{
\item{train}{A data set to perform model training.}

\item{test}{A data set to estimate concordance, from fit model with \code{train}.
Set to \code{train} if estimating on the same data}

\item{event_time}{Character vector of length 1 with event times, passed to
\code{\link[survival]{Surv}}}

\item{event_status}{Character vector of length 1 with event status, passed to
\code{\link[survival]{Surv}}}

\item{weight_column}{Character vector of length 1 with weights for
model.  If no weights are available, set to \code{NULL}}

\item{all_variables}{Character vector of variables to put in the
model.  All must be in \code{data}.}

\item{cfit_args}{Arguments passed to \code{\link[survival]{concordancefit}}.  If
\code{strata} is to be passed, set \code{strata_column} in this list.}

\item{...}{Additional arguments to pass to \code{\link[survival]{coxph}}}
}
\value{
A list of concordance and the model fit with the training data
}
\description{
Estimate Out-of-Sample Concordance
}
