% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPlot.R
\name{summary_cfd}
\alias{summary_cfd}
\title{Summary}
\usage{
summary_cfd(data, max.print = 10)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and
\code{state}, associated state.}

\item{max.print}{maximal number of states to display}
}
\value{
a list containing:
\itemize{
  \item \code{nRow} number of rows
  \item \code{nInd} number of individuals
  \item \code{timeRange} minimal and maximal time value
  \item \code{uniqueStart} TRUE, if all individuals have the same time start value
  \item \code{uniqueEnd} TRUE, if all individuals have the same time start value
  \item \code{states} vector containing the different states
  \item \code{visit} number of individuals visiting each state
}
}
\description{
Get a summary of the data.frame containing categorical functional data
}
\examples{
data(biofam2)
summary_cfd(biofam2)
}
\seealso{
Other Descriptive statistics: 
\code{\link{boxplot.timeSpent}()},
\code{\link{compute_duration}()},
\code{\link{compute_number_jumps}()},
\code{\link{compute_time_spent}()},
\code{\link{estimate_pt}()},
\code{\link{hist.duration}()},
\code{\link{hist.njump}()},
\code{\link{plot.pt}()},
\code{\link{plotData}()},
\code{\link{statetable}()}
}
\author{
Quentin Grimonprez
}
\concept{Descriptive statistics}
