% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_play.R
\name{cfbd_play_stats_player}
\alias{cfbd_play_stats_player}
\title{\strong{Gets player info associated by play}}
\usage{
cfbd_play_stats_player(
  year = NULL,
  week = NULL,
  team = NULL,
  game_id = NULL,
  athlete_id = NULL,
  stat_type_id = NULL,
  season_type = "regular"
)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier}

\item{team}{(\emph{String} optional): D-I Team}

\item{game_id}{(\emph{Integer} optional): Game ID filter for querying a single game
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}

\item{athlete_id}{(\emph{Integer} optional): Athlete ID filter for querying a single athlete
Can be found using the \code{\link[=cfbd_player_info]{cfbd_player_info()}} function.}

\item{stat_type_id}{(\emph{Integer} optional): Stat Type ID filter for querying a single stat type
Can be found using the \code{\link[=cfbd_play_stats_types]{cfbd_play_stats_types()}} function}

\item{season_type}{(\emph{String} default regular): Season type - regular, postseason, both, allstar, spring_regular, spring_postseason}
}
\value{
\code{\link[=cfbd_play_stats_player]{cfbd_play_stats_player()}} - A data frame with 54 variables:
\describe{
\item{\code{play_id}: character.}{Referencing play id.}
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{season}: integer.}{Season of the play.}
\item{\code{week}: integer.}{Week of the play.}
\item{\code{opponent}: character.}{Opponent of the offense on the play.}
\item{\code{team_score}: integer.}{Offense team score.}
\item{\code{opponent_score}: integer.}{Defense team score.}
\item{\code{drive_id}: character.}{Referencing drive id.}
\item{\code{period}: integer.}{Game period (quarter) of the play.}
\item{\code{yards_to_goal}: integer.}{Yards to the goal line (~0-100).}
\item{\code{down}: integer.}{Down of the play.}
\item{\code{distance}: integer.}{Distance to the sticks, i.e. 1st down or goal-line in goal-to-go situations.}
\item{\code{reception_player_id}: character.}{Pass receiver player reference id.}
\item{\code{reception_player}: character.}{Pass receiver player name.}
\item{\code{reception_yds}: integer.}{Reception yards.}
\item{\code{completion_player_id}: character.}{Passing player reference id.}
\item{\code{completion_player}: character.}{Passing player name.}
\item{\code{completion_yds}: integer.}{Passing yards.}
\item{\code{rush_player_id}: character.}{Rushing player reference id.}
\item{\code{rush_player}: character.}{Rushing player name.}
\item{\code{rush_yds}: integer.}{Rushing yards.}
\item{\code{interception_player_id}: character.}{Intercepting player reference id.}
\item{\code{interception_player}: character.}{Intercepting player name.}
\item{\code{interception_stat}: integer.}{Intercepting stat.}
\item{\code{interception_thrown_player_id}: character.}{Interception passing player reference id.}
\item{\code{interception_thrown_player}: character.}{Interception passing player name.}
\item{\code{interception_thrown_stat}: integer.}{Interception thrown stat.}
\item{\code{touchdown_player_id}: character.}{Touchdown scoring player reference id.}
\item{\code{touchdown_player}: character.}{Touchdown scoring player name.}
\item{\code{touchdown_stat}: integer.}{Touchdown scoring stat.}
\item{\code{incompletion_player_id}: character.}{Incomplete receiver player reference id.}
\item{\code{incompletion_player}: character.}{Incomplete receiver player name.}
\item{\code{incompletion_stat}: integer.}{Incomplete stat.}
\item{\code{target_player_id}: character.}{Targeted receiver player reference id.}
\item{\code{target_player}: character.}{Targeted receiver player name.}
\item{\code{target_stat}: integer.}{Target stat.}
\item{\code{fumble_recovered_player_id}: logical.}{Fumble recovering player reference id.}
\item{\code{fumble_recovered_player}: logical.}{Fumble recovering player name.}
\item{\code{fumble_recovered_stat}: logical.}{Fumble recovered stat.}
\item{\code{fumble_forced_player_id}: logical.}{Fumble forcing player reference id.}
\item{\code{fumble_forced_player}: logical.}{Fumble forcing player name.}
\item{\code{fumble_forced_stat}: logical.}{Fumble forced stat.}
\item{\code{fumble_player_id}: logical.}{Fumbling player reference id.}
\item{\code{fumble_player}: logical.}{Fumbling player name.}
\item{\code{fumble_stat}: logical.}{Fumble stat.}
\item{\code{sack_player_id}: character.}{Sacking player(s) reference id.}
\item{\code{sack_player}: character.}{Sacking player(s) name.}
\item{\code{sack_stat}: integer.}{Sack stat.}
\item{\code{sack_taken_player_id}: character.}{Sack taking player reference id.}
\item{\code{sack_taken_player}: character.}{Sack taking player name.}
\item{\code{sack_taken_stat}: integer.}{Sack taken stat.}
\item{\code{pass_breakup_player_id}: logical.}{Pass breakup player reference id.}
\item{\code{pass_breakup_player}: logical.}{Pass breakup player name.}
\item{\code{pass_breakup_stat}: logical.}{Pass breakup (PBU) stat.}
\item{\code{field_goal_attempt_player_id}: character.}{Field goal attempting player reference id.}
\item{\code{field_goal_attempt_player}: character.}{Field goal attempting player name.}
\item{\code{field_goal_attempt_stat}: integer.}{Field goal attempt stat.}
\item{\code{field_goal_made_player_id}: character.}{Field goal making player reference id.}
\item{\code{field_goal_made_player}: character.}{Field goal making player name.}
\item{\code{field_goal_made_stat}: integer.}{Field goal made stat.}
\item{\code{field_goal_missed_player_id}: character.}{Field goal missing player reference id.}
\item{\code{field_goal_missed_player}: character.}{Field goal missing player name.}
\item{\code{field_goal_missed_stat}: integer.}{Field goal missed stat.}
\item{\code{field_goal_blocked_player_id}: character.}{Field goal blocked player reference id.}
\item{\code{field_goal_blocked_player}: character.}{Field goal blocked player name.}
\item{\code{field_goal_blocked_stat}: integer.}{Field goal blocked stat.}
}
}
\description{
\strong{Gets player info associated by play}
}
\examples{
\donttest{
  try(cfbd_play_stats_player(game_id = 401628414))
  try(cfbd_play_stats_player(year = 2025, week = 1))
}
}
\seealso{
Other CFBD PBP: 
\code{\link{cfbd_live_plays}()},
\code{\link{cfbd_pbp_data}()},
\code{\link{cfbd_play_stats_types}()},
\code{\link{cfbd_play_types}()},
\code{\link{cfbd_plays}()}
}
\concept{CFBD PBP}
\keyword{PBP}
\keyword{Player}
